/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollection;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.CompoundObjectReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.xml.sax.SAXException;

public class TemplateReadHandler
extends CompoundObjectReadHandler {
    private TemplateCollection templateCollection;
    private boolean nameRequired;

    public TemplateReadHandler(boolean nameRequired) {
        super(null);
        this.nameRequired = nameRequired;
    }

    @Override
    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) throws SAXException {
        super.init(rootHandler, uri, tagName);
        this.templateCollection = (TemplateCollection)rootHandler.getHelperObject("::template-factory");
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String templateName = attrs.getValue(this.getUri(), "name");
        if (this.nameRequired && templateName == null) {
            throw new ParseException("The 'name' attribute is required for template definitions", this.getRootHandler().getDocumentLocator());
        }
        String references = attrs.getValue(this.getUri(), "references");
        if (references == null) {
            throw new ParseException("The 'references' attribute is required for template definitions", this.getRootHandler().getDocumentLocator());
        }
        TemplateDescription template = this.templateCollection.getTemplate(references);
        if (template == null) {
            throw new ParseException("The template '" + references + "' is not defined", this.getRootHandler().getDocumentLocator());
        }
        template = (TemplateDescription)template.getInstance();
        if (templateName != null) {
            template.setName(templateName);
            this.templateCollection.addTemplate(template);
        }
        this.setObjectDescription(template);
    }
}

