/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PageDefinitionReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(PageDefinitionReadHandler.class);
    private PageDefinition pageDefinition;

    protected void startParsing(Attributes attrs) throws SAXException {
        Object o = this.getRootHandler().getHelperObject("::Report");
        if (!(o instanceof MasterReport)) {
            return;
        }
        MasterReport report = (MasterReport)o;
        PageFormat format = report.getPageDefinition().getPageFormat(0);
        PageFormat definedFormat = this.configurePageSizeAndMargins(attrs, format);
        int horizontalSpan = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), "horizontal-span"), (int)1);
        int verticalSpan = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), "vertical-span"), (int)1);
        this.pageDefinition = new SimplePageDefinition(definedFormat, horizontalSpan, verticalSpan);
        report.setPageDefinition(this.pageDefinition);
    }

    private PageFormat configurePageSize(PageFormat defaultPageFormat, Attributes atts) throws SAXException {
        String pageformatName = atts.getValue(this.getUri(), "pageformat");
        String orientation = atts.getValue(this.getUri(), "orientation");
        int orientationVal = orientation == null ? 1 : ("landscape".equals(orientation) ? 0 : ("reverse-landscape".equals(orientation) ? 2 : 1));
        if (pageformatName != null) {
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatName);
            if (p == null) {
                logger.warn((Object)("Paper size '" + pageformatName + "' is not regognized."));
                return defaultPageFormat;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        if (atts.getValue(this.getUri(), "width") != null && atts.getValue(this.getUri(), "height") != null) {
            int[] pageformatData = new int[]{ParserUtil.parseInt((String)atts.getValue(this.getUri(), "width"), (String)"Specified attribute 'width' is not valid", (Locator)this.getLocator()), ParserUtil.parseInt((String)atts.getValue(this.getUri(), "height"), (String)"Specified attribute 'height' is not valid", (Locator)this.getLocator())};
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatData);
            if (p == null) {
                logger.warn((Object)("Unable to create the requested Paper size with width " + pageformatData[0] + " and height " + pageformatData[1]));
                return defaultPageFormat;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        logger.info((Object)"Insufficient Data to create a pageformat: Returned default.");
        return defaultPageFormat;
    }

    private PageFormat configurePageSizeAndMargins(Attributes atts, PageFormat format) throws SAXException {
        float defTopMargin = (float)format.getImageableY();
        float defBottomMargin = (float)(format.getHeight() - format.getImageableHeight() - format.getImageableY());
        float defLeftMargin = (float)format.getImageableX();
        float defRightMargin = (float)(format.getWidth() - format.getImageableWidth() - format.getImageableX());
        format = this.configurePageSize(format, atts);
        defTopMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), "margin-top"), (float)defTopMargin);
        defBottomMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), "margin-bottom"), (float)defBottomMargin);
        defLeftMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), "margin-left"), (float)defLeftMargin);
        defRightMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), "margin-right"), (float)defRightMargin);
        Paper p = format.getPaper();
        switch (format.getOrientation()) {
            case 1: {
                PageFormatFactory.getInstance().setBorders(p, defTopMargin, defLeftMargin, defBottomMargin, defRightMargin);
                break;
            }
            case 2: {
                PageFormatFactory.getInstance().setBorders(p, defLeftMargin, defBottomMargin, defRightMargin, defTopMargin);
                break;
            }
            case 0: {
                PageFormatFactory.getInstance().setBorders(p, defRightMargin, defTopMargin, defLeftMargin, defBottomMargin);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected paper orientation.");
            }
        }
        format.setPaper(p);
        return format;
    }

    public Object getObject() throws SAXException {
        return this.pageDefinition;
    }
}

