/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.styles.BundleStyleSetWriteHandler;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;

public class BundleStyleRegistry {
    private static final BundleStyleRegistry instance = new BundleStyleRegistry();
    private ArrayList<Class<? extends BundleStyleSetWriteHandler>> styleSetWriteHandlers = new ArrayList();
    private AttributeMap<Class<? extends StyleReadHandler>> styleReadHandlers = new AttributeMap();

    public static BundleStyleRegistry getInstance() {
        return instance;
    }

    private BundleStyleRegistry() {
    }

    public BundleStyleSetWriteHandler[] getWriteHandlers() {
        ArrayList<BundleStyleSetWriteHandler> retval = new ArrayList<BundleStyleSetWriteHandler>();
        for (int i = 0; i < this.styleSetWriteHandlers.size(); ++i) {
            try {
                Class<? extends BundleStyleSetWriteHandler> c = this.styleSetWriteHandlers.get(i);
                retval.add(c.newInstance());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval.toArray(new BundleStyleSetWriteHandler[retval.size()]);
    }

    public StyleReadHandler getReadHandler(String namespace, String tagName, Locator locator) throws ParseException {
        try {
            Class attribute = (Class)this.styleReadHandlers.getAttribute(namespace, tagName);
            if (attribute != null) {
                return (StyleReadHandler)attribute.newInstance();
            }
            throw new ParseException("Failed to locate style-read-handler for [" + namespace + "|" + tagName + "]", locator);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("Failed to instantiate style-read-handler for [" + namespace + "|" + tagName + "]", locator);
        }
    }

    public void register(String namespace, String tagName, Class<? extends StyleReadHandler> readHandler) {
        if (readHandler == null) {
            throw new IllegalStateException();
        }
        if (namespace == null) {
            throw new IllegalStateException();
        }
        if (tagName == null) {
            throw new IllegalStateException();
        }
        this.styleReadHandlers.setAttribute(namespace, tagName, readHandler);
    }

    public void register(Class<? extends BundleStyleSetWriteHandler> writeHandler) {
        if (writeHandler == null) {
            return;
        }
        this.styleSetWriteHandlers.add(writeHandler);
    }
}

