/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xml.internal;

import java.awt.Color;
import java.beans.PropertyEditor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xml.internal.XmlTableOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class XmlDocumentWriter
extends IterateStructuralProcessStep {
    private static final String LAYOUT_OUTPUT_NAMESPACE = "http://reporting.pentaho.org/namespaces/output/layout-output/table/1.0";
    private static final Log logger = LogFactory.getLog(XmlDocumentWriter.class);
    private OutputStream outputStream;
    private StrictBounds drawArea;
    private XmlWriter xmlWriter;
    private FastDecimalFormat pointIntConverter;
    private FastDecimalFormat pointConverter;
    private FastDecimalFormat pointShortConverter;
    private boolean ignoreEmptyBorders;
    private CellBackgroundProducer cellBackgroundProducer;
    private OutputProcessorMetaData metaData;
    private boolean tableOpen;

    public XmlDocumentWriter(OutputStream outputStream, OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.outputStream = outputStream;
        this.pointConverter = new FastDecimalFormat("0.0####", Locale.US);
        this.pointShortConverter = new FastDecimalFormat("0.#####", Locale.US);
        this.pointIntConverter = new FastDecimalFormat("0", Locale.US);
        this.ignoreEmptyBorders = true;
    }

    public void open() throws IOException {
        DefaultTagDescription td = new DefaultTagDescription();
        td.setNamespaceHasCData(LAYOUT_OUTPUT_NAMESPACE, false);
        td.setElementHasCData(LAYOUT_OUTPUT_NAMESPACE, "text", true);
        String encoding = this.metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xml.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, encoding));
        this.xmlWriter = new XmlWriter((Writer)writer, (TagDescription)td);
        this.xmlWriter.writeXmlDeclaration(null);
        AttributeList attrs = new AttributeList();
        attrs.addNamespaceDeclaration("", LAYOUT_OUTPUT_NAMESPACE);
        this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "layout-output", attrs, false);
    }

    public void close() throws IOException {
        this.xmlWriter.writeCloseTag();
        this.xmlWriter.close();
    }

    public void processTableContent(LogicalPageBox logicalPageBox, OutputProcessorMetaData metaData, TableContentProducer contentProducer, boolean incremental) throws IOException {
        SheetLayout sheetLayout = contentProducer.getSheetLayout();
        int columnCount = contentProducer.getColumnCount();
        int rowCount = contentProducer.getRowCount();
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        if (incremental && startRow == finishRow) {
            return;
        }
        if (this.cellBackgroundProducer == null) {
            this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
        }
        if (!this.tableOpen) {
            this.tableOpen = true;
            AttributeList pageAttributes = new AttributeList();
            pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "col-count", this.pointIntConverter.format((Object)columnCount));
            pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "row-count", this.pointIntConverter.format((Object)rowCount));
            pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "sheet-name", contentProducer.getSheetName());
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "table", pageAttributes, false);
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "cols", false);
            for (int i = 0; i < columnCount; ++i) {
                double cellWidth = StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(i, i + 1));
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "column", "width", this.pointShortConverter.format((Object)cellWidth), true);
            }
            this.xmlWriter.writeCloseTag();
        }
        for (int row = startRow; row < finishRow; ++row) {
            AttributeList rowAttributes = new AttributeList();
            double rowHeight = StrictGeomUtility.toExternalValue(sheetLayout.getRowHeight(row));
            rowAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointShortConverter.format((Object)rowHeight));
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "row", rowAttributes, false);
            for (int col = 0; col < columnCount; col = (int)((short)(col + 1))) {
                RenderBox content = contentProducer.getContent(row, col);
                if (content == null) {
                    CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                    RenderBox backgroundBox = contentProducer.getBackground(row, col);
                    CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPageBox, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(logicalPageBox, sheetLayout, col, row, true, sectionType);
                    if (background == null) {
                        this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "empty-cell", true);
                        continue;
                    }
                    this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "empty-cell", this.createCellAttributes(background), false);
                    this.writeAttributes(background.getAttributes(), background.getElementType());
                    this.xmlWriter.writeCloseTag();
                    continue;
                }
                if (!content.isCommited()) {
                    throw new InvalidReportStateException("Uncommited content encountered");
                }
                long contentOffset = contentProducer.getContentOffset(row, col);
                TableRectangle rectangle = sheetLayout.getTableBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight(), null);
                if (!rectangle.isOrigin(col, row)) {
                    this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "spanned-cell", true);
                    continue;
                }
                CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                CellBackground realBackground = this.cellBackgroundProducer.getBackgroundForBox(logicalPageBox, sheetLayout, rectangle.getX1(), rectangle.getY1(), rectangle.getColumnSpan(), rectangle.getRowSpan(), false, sectionType, content);
                AttributeList attributeList = realBackground != null ? this.createCellAttributes(realBackground) : new AttributeList();
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "row-span", this.pointIntConverter.format((Object)rectangle.getRowSpan()));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "col-span", this.pointIntConverter.format((Object)rectangle.getColumnSpan()));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href", (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href-window", (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_WINDOW));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href-title", (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TITLE));
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "cell", attributeList, false);
                this.writeAttributes(content.getAttributes(), content.getElementType());
                this.processBoxChilds(content);
                this.xmlWriter.writeCloseTag();
                content.setFinishedTable(true);
            }
            this.xmlWriter.writeCloseTag();
        }
        if (!incremental) {
            this.xmlWriter.writeCloseTag();
            this.tableOpen = false;
        }
    }

    private AttributeList createBoxAttributeList(RenderBox box) {
        Color color;
        BorderCorner bottomRight;
        BorderCorner bottomLeft;
        BorderCorner topRight;
        BorderCorner topLeft;
        BorderEdge right;
        BorderEdge bottom;
        BorderEdge left;
        AttributeList attributeList = new AttributeList();
        if (!StringUtils.isEmpty((String)box.getName())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "name", box.getName());
        }
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "type", box.getClass().getSimpleName());
        BoxDefinition definition = box.getBoxDefinition();
        Border border = definition.getBorder();
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        BorderEdge top = border.getTop();
        if (!BorderEdge.EMPTY.equals(top) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-color", ColorValueConverter.colorToString(top.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getBorderTop())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-style", String.valueOf(top.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(left = border.getLeft()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-color", ColorValueConverter.colorToString(left.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getBorderLeft())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-style", String.valueOf(left.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(bottom = border.getBottom()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-color", ColorValueConverter.colorToString(bottom.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getBorderBottom())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-style", String.valueOf(bottom.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(right = border.getRight()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-color", ColorValueConverter.colorToString(right.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getBorderRight())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-style", String.valueOf(right.getBorderStyle()));
        }
        if (!this.isEmptyCorner(topLeft = border.getTopLeft())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-left-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topLeft.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-left-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topLeft.getHeight())));
        }
        if (!this.isEmptyCorner(topRight = border.getTopRight())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-right-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topRight.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-right-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topRight.getHeight())));
        }
        if (!this.isEmptyCorner(bottomLeft = border.getBottomLeft())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-left-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomLeft.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-left-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomLeft.getHeight())));
        }
        if (!this.isEmptyCorner(bottomRight = border.getBottomRight())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-right-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomRight.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-right-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomRight.getHeight())));
        }
        if (sblp.getMarginTop() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-top", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getMarginTop())));
        }
        if (sblp.getMarginLeft() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-left", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getMarginLeft())));
        }
        if (sblp.getMarginBottom() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-bottom", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getMarginBottom())));
        }
        if (sblp.getMarginRight() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-right", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(sblp.getMarginRight())));
        }
        if (definition.getPaddingTop() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-top", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(definition.getPaddingTop())));
        }
        if (definition.getPaddingLeft() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-left", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(definition.getPaddingLeft())));
        }
        if (definition.getPaddingBottom() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-bottom", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(definition.getPaddingBottom())));
        }
        if (definition.getPaddingRight() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-right", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(definition.getPaddingRight())));
        }
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(box.getX())));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(box.getY())));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(box.getWidth())));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(box.getHeight())));
        Color backgroundColor = (Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        if (backgroundColor != null) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "background-color", ColorValueConverter.colorToString(backgroundColor));
        }
        if ((color = (Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.PAINT)) != null) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "color", ColorValueConverter.colorToString(color));
        }
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-face", (String)box.getStyleSheet().getStyleProperty(TextStyleKeys.FONT));
        Object o = box.getStyleSheet().getStyleProperty(TextStyleKeys.FONTSIZE);
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-size", this.pointIntConverter.format(o));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-bold", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.BOLD)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-italics", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.ITALIC)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-underline", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.UNDERLINED)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-strikethrough", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.STRIKETHROUGH)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "anchor", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.ANCHOR_NAME));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href-window", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_WINDOW));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href-title", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TITLE));
        return attributeList;
    }

    private void writeElementAttributes(RenderNode element) throws IOException {
        ReportAttributeMap<Object> attributes = element.getAttributes();
        ElementType type = element.getElementType();
        this.writeAttributes(attributes, type);
    }

    private void writeAttributes(ReportAttributeMap attributes, ElementType type) throws IOException {
        if (type == null) {
            type = AutoLayoutBoxType.INSTANCE;
        }
        Set collection = attributes.keySet();
        AttributeMap.DualKey[] attributeNames = collection.toArray(new AttributeMap.DualKey[collection.size()]);
        Arrays.sort(attributeNames, new DualKeySorter());
        for (int j = 0; j < attributeNames.length; ++j) {
            AttributeMetaData attrMeta;
            String name;
            Object value;
            String namespace = attributeNames[j].namespace;
            if ("http://reporting.pentaho.org/namespaces/report-designer/2.0".equals(namespace) || (value = attributes.getAttribute(namespace, name = attributeNames[j].name)) == null || !this.metaData.isFeatureSupported(XmlTableOutputProcessorMetaData.WRITE_RESOURCEKEYS) && value instanceof ResourceKey || (attrMeta = type.getMetaData().getAttributeDescription(namespace, name)) == null) continue;
            AttributeList attList = new AttributeList();
            if (value instanceof String) {
                String s = (String)value;
                if (StringUtils.isEmpty((String)s)) continue;
                if (!this.xmlWriter.isNamespaceDefined(namespace) && !attList.isNamespaceUriDefined(namespace)) {
                    attList.addNamespaceDeclaration("autoGenNs", namespace);
                }
                attList.setAttribute(namespace, name, s);
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "attribute", attList, true);
                continue;
            }
            if (!this.xmlWriter.isNamespaceDefined(namespace) && !attList.isNamespaceUriDefined(namespace)) {
                attList.addNamespaceDeclaration("autoGenNs", namespace);
            }
            try {
                String textValue;
                PropertyEditor propertyEditor = attrMeta.getEditor();
                if (propertyEditor != null) {
                    propertyEditor.setValue(value);
                    textValue = propertyEditor.getAsText();
                } else {
                    textValue = ConverterRegistry.toAttributeValue(value);
                }
                if (textValue != null) {
                    if ("".equals(textValue)) continue;
                    attList.setAttribute(namespace, name, textValue);
                    this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "attribute", attList, true);
                    continue;
                }
                if (value instanceof ResourceKey) {
                    ResourceKey reskey = (ResourceKey)value;
                    String identifierAsString = reskey.getIdentifierAsString();
                    attList.setAttribute(namespace, name, "resource-key:" + reskey.getSchema() + ":" + identifierAsString);
                    this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "attribute", attList, true);
                    continue;
                }
                logger.debug((Object)("Attribute '" + namespace + '|' + name + "' is not convertible to a text - returned null: " + value));
                continue;
            }
            catch (BeanException e) {
                if (!attrMeta.isTransient()) {
                    logger.warn((Object)("Attribute '" + namespace + '|' + name + "' is not convertible with the bean-methods"));
                    continue;
                }
                logger.debug((Object)("Attribute '" + namespace + '|' + name + "' is not convertible with the bean-methods"));
            }
        }
    }

    private boolean isEmptyCorner(BorderCorner corner) {
        if (!this.ignoreEmptyBorders) {
            return false;
        }
        return corner.getWidth() == 0L && corner.getHeight() == 0L;
    }

    private AttributeList createCellAttributes(CellBackground border) {
        String[] anchors;
        Color backgroundColor;
        BorderCorner bottomRight;
        BorderCorner bottomLeft;
        BorderCorner topRight;
        BorderCorner topLeft;
        BorderEdge right;
        BorderEdge bottom;
        BorderEdge left;
        AttributeList attributeList = new AttributeList();
        BorderEdge top = border.getTop();
        if (!BorderEdge.EMPTY.equals(top) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-color", ColorValueConverter.colorToString(top.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(top.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-style", String.valueOf(top.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(left = border.getLeft()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-color", ColorValueConverter.colorToString(left.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(left.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-style", String.valueOf(left.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(bottom = border.getBottom()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-color", ColorValueConverter.colorToString(bottom.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottom.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-style", String.valueOf(bottom.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(right = border.getRight()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-color", ColorValueConverter.colorToString(right.getColor()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(right.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-style", String.valueOf(right.getBorderStyle()));
        }
        if (!this.isEmptyCorner(topLeft = border.getTopLeft())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-left-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topLeft.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-left-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topLeft.getHeight())));
        }
        if (!this.isEmptyCorner(topRight = border.getTopRight())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-right-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topRight.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-right-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(topRight.getHeight())));
        }
        if (!this.isEmptyCorner(bottomLeft = border.getBottomLeft())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-left-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomLeft.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-left-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomLeft.getHeight())));
        }
        if (!this.isEmptyCorner(bottomRight = border.getBottomRight())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-right-x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomRight.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-right-y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(bottomRight.getHeight())));
        }
        if ((backgroundColor = border.getBackgroundColor()) != null) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "background-color", ColorValueConverter.colorToString(backgroundColor));
        }
        if ((anchors = border.getAnchors()).length > 0) {
            StringBuilder anchorText = new StringBuilder(100);
            for (int i = 0; i < anchors.length; ++i) {
                String anchor = anchors[i];
                if (i == 0) {
                    anchorText.append(' ');
                }
                anchorText.append(anchor);
            }
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "anchor", anchorText.toString());
        }
        return attributeList;
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        try {
            int nodeType = box.getNodeType();
            if ((nodeType & 0x812) == 2066) {
                AttributeList list = this.createBoxAttributeList(box);
                list.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "type", box.getName());
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "page-area", list, false);
                this.writeElementAttributes(box);
                return true;
            }
            if (nodeType == 274) {
                return this.startBox(box, "p");
            }
            return this.startBox(box, "block");
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void finishBlockBox(BlockRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (box.getNodeType() == 322) {
            return this.startBox(box, "line");
        }
        return this.startBox(box, "inline");
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        try {
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "other-box", this.createBoxAttributeList(box), false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void finishOtherBox(RenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        return this.startBox(box, "canvas");
    }

    private boolean startBox(RenderBox box, String tagName) {
        try {
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, tagName, this.createBoxAttributeList(box), false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void finishCanvasBox(CanvasRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        try {
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "row", this.createBoxAttributeList(box), false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void finishRowBox(RenderBox box) {
        this.finishBox();
    }

    private void finishBox() {
        try {
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        try {
            int nodeType = node.getNodeType();
            if (nodeType == 17) {
                RenderableText text = (RenderableText)node;
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getX())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getY())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getWidth())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getHeight())));
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "text", attributeList, false);
                this.xmlWriter.writeTextNormalized(text.getRawText(), true);
                this.xmlWriter.writeCloseTag();
            } else if (nodeType == 273) {
                RenderableComplexText renderableComplexText = (RenderableComplexText)node;
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getX())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getY())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getWidth())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getHeight())));
                String text = renderableComplexText.getRawText();
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "text", attributeList, false);
                this.xmlWriter.writeTextNormalized(text, true);
                this.xmlWriter.writeCloseTag();
            } else if (nodeType == 65) {
                SpacerRenderNode spacer = (SpacerRenderNode)node;
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getWidth())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getHeight())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "preserve", String.valueOf(!spacer.isDiscardable()));
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "spacer", attributeList, true);
            }
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox node) {
        try {
            RenderableReplacedContent prc = node.getContent();
            AttributeList attributeList = new AttributeList();
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getX())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getY())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(node.getHeight())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "source", String.valueOf(prc.getSource()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "content-width", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(prc.getContentWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "content-height", this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(prc.getContentHeight())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "requested-width", this.convertRenderLength(prc.getRequestedWidth()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "requested-height", this.convertRenderLength(prc.getRequestedHeight()));
            Object o = prc.getRawObject();
            if (o != null) {
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "raw-object-type", o.getClass().getName());
            } else {
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "raw-object-type", "null");
            }
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "replaced-content", attributeList, false);
            this.writeElementAttributes(node);
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    private String convertRenderLength(RenderLength length) {
        if (length == null) {
            return null;
        }
        if (RenderLength.AUTO.equals(length)) {
            return "auto";
        }
        if (length.isPercentage()) {
            return this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(-length.getValue())) + '%';
        }
        return this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(length.getValue()));
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        try {
            AttributeList attrs = this.createBoxAttributeList(box);
            attrs.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "col-span", String.valueOf(box.getColSpan()));
            attrs.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "row-span", String.valueOf(box.getRowSpan()));
            attrs.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "col-index", String.valueOf(box.getColumnIndex()));
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "table-cell", attrs, false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void finishTableCellBox(TableCellRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        return this.startBox(box, "table-row");
    }

    @Override
    protected void finishTableRowBox(TableRowRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        return this.startBox(box, "table-section");
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return this.startBox(box, "colgroup");
    }

    @Override
    protected void finishTableColumnGroupBox(TableColumnGroupNode box) {
        this.finishBox();
    }

    @Override
    protected boolean startTableBox(TableRenderBox box) {
        return this.startBox(box, "table");
    }

    @Override
    protected void finishTableBox(TableRenderBox box) {
        this.finishBox();
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        return this.startBox(box, "auto");
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        this.finishBox();
    }

    private static class DualKeySorter
    implements Comparator<AttributeMap.DualKey> {
        private DualKeySorter() {
        }

        @Override
        public int compare(AttributeMap.DualKey o1, AttributeMap.DualKey o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int ns = o1.namespace.compareTo(o2.namespace);
            if (ns != 0) {
                return ns;
            }
            return o1.name.compareTo(o2.name);
        }
    }
}

