/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public interface StyleBuilder {
    public void clear();

    public void append(CSSKeys var1, String var2);

    public void appendRaw(CSSKeys var1, String var2);

    public void append(CSSKeys var1, String var2, String var3);

    public void append(CSSKeys var1, String var2, boolean var3);

    public void append(CSSKeys var1, String var2, String var3, boolean var4);

    public String toString();

    public void print(Writer var1, boolean var2) throws IOException;

    public String toString(boolean var1);

    public String printEdgeAsCSS(BorderEdge var1);

    public String printCornerAsCSS(BorderCorner var1);

    public NumberFormat getPointConverter();

    public StyleCarrier[] toArray();

    public boolean isEmpty();

    public static enum CSSKeys {
        COLOR("color", true),
        PADDING("padding"),
        PADDING_TOP("padding-top"),
        PADDING_BOTTOM("padding-bottom"),
        PADDING_LEFT("padding-left"),
        PADDING_RIGHT("padding-right"),
        FONT_SIZE("font-size", true),
        FONT_FAMILY("font-family", true),
        FONT_WEIGHT("font-weight", true),
        FONT_STYLE("font-style", true),
        TEXT_DECORATION("text-decoration", true),
        TEXT_ALIGN("text-align", true),
        WORD_SPACING("word-spacing", true),
        LETTER_SPACING("letter-spacing", true),
        WHITE_SPACE("white-space", true),
        BORDER_COLLAPSE("border-collapse"),
        EMPTY_CELLS("empty-cells"),
        TABLE_LAYOUT("table-layout"),
        BORDER("border"),
        BORDER_TOP("border-top"),
        BORDER_LEFT("border-left"),
        BORDER_BOTTOM("border-bottom"),
        BORDER_RIGHT("border-right"),
        MOZ_BORDER_RADIUS_TOP_LEFT("-moz-border-radius-topleft"),
        MOZ_BORDER_RADIUS_TOP_RIGHT("-moz-border-radius-topright"),
        MOZ_BORDER_RADIUS_BOTTOM_LEFT("-moz-border-radius-bottomleft"),
        MOZ_BORDER_RADIUS_BOTTOM_RIGHT("-moz-border-radius-bottomright"),
        BORDER_TOP_LEFT_RADIUS("border-top-left-radius"),
        BORDER_TOP_RIGHT_RADIUS("border-top-right-radius"),
        BORDER_BOTTOM_LEFT_RADIUS("border-bottom-left-radius"),
        BORDER_BOTTOM_RIGHT_RADIUS("border-bottom-right-radius"),
        BACKGROUND_COLOR("background-color", true),
        OVERFLOW("overflow"),
        WIDTH("width"),
        HEIGHT("height"),
        TRANSFORM_ORIGIN("transform-origin"),
        TRANSFORM("transform"),
        DIRECTION("direction");

        private String cssName;
        private boolean inherit;

        private CSSKeys(String cssName, boolean inherit) {
            this.cssName = cssName;
            this.inherit = inherit;
        }

        private CSSKeys(String cssName) {
            this.cssName = cssName;
        }

        public String getCssName() {
            return this.cssName;
        }

        public boolean isInherit() {
            return this.inherit;
        }
    }

    public static class StyleCarrier {
        private CSSKeys key;
        private String value;
        private String unit;

        public StyleCarrier(CSSKeys key, String value, String unit) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.key = key;
            this.value = value;
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public CSSKeys getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyleCarrier that = (StyleCarrier)o;
            if (!this.key.equals((Object)that.key)) {
                return false;
            }
            if (!ObjectUtilities.equal((Object)this.value, (Object)that.value)) {
                return false;
            }
            return ObjectUtilities.equal((Object)this.unit, (Object)that.unit);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StyleCarrier{key='" + (Object)((Object)this.key) + '\'' + ", value='" + this.value + '\'' + ", unit='" + this.unit + '\'' + '}';
        }
    }
}

