/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.AbstractFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.CellLayoutInfo;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelPrinter;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FastExcelFormattedDataBuilder
extends AbstractFormattedDataBuilder {
    private final HashMap<InstanceID, CellLayoutInfo> layout;
    private ArrayList<CellLayoutInfo> backgroundCells;
    private long[] cellHeights;
    private final FastExcelPrinter excelPrinter;

    public FastExcelFormattedDataBuilder(HashMap<InstanceID, CellLayoutInfo> layout, ArrayList<CellLayoutInfo> backgroundCells, long[] cellHeights, FastExcelPrinter excelPrinter) {
        this.layout = layout;
        this.backgroundCells = backgroundCells;
        this.cellHeights = cellHeights;
        this.excelPrinter = excelPrinter;
    }

    @Override
    public void compute(Band band, ExpressionRuntime runtime, OutputStream out) throws ReportProcessingException, ContentProcessingException, IOException {
        SimpleStyleSheet computedStyle = band.getComputedStyle();
        if (!computedStyle.getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return;
        }
        this.excelPrinter.startSection(band, this.cellHeights);
        this.compute(band, runtime);
        this.excelPrinter.endSection(band, this.backgroundCells);
    }

    @Override
    protected void inspect(AbstractReportDefinition reportDefinition) {
        this.inspectElement(reportDefinition);
    }

    @Override
    protected void inspectElement(ReportElement element) {
        CellLayoutInfo tableRectangle = this.layout.get(element.getObjectID());
        if (tableRectangle != null) {
            try {
                this.excelPrinter.print(tableRectangle, element, this.getRuntime());
            }
            catch (ContentProcessingException e) {
                throw new InvalidReportStateException(e);
            }
        }
    }
}

