/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableLayoutProducer;

public class TemplatingOutputProcessor
extends AbstractOutputProcessor {
    private OutputProcessorMetaData metaData;
    private FastExportTemplateListener templateListener;

    public TemplatingOutputProcessor(OutputProcessorMetaData metaData, FastExportTemplateListener templateListener) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.templateListener = templateListener;
        this.metaData = metaData;
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) {
        if (this.templateListener != null) {
            this.templateListener.produceTemplate(logicalPage);
        }
    }

    @Override
    protected void processPaginationContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
        if (this.templateListener != null) {
            this.templateListener.produceTemplate(logicalPage);
        }
    }

    public static TableContentProducer produceTableLayout(LogicalPageBox pageBox, SheetLayout layout, OutputProcessorMetaData metaData) {
        layout.clearVerticalInfo();
        TableLayoutProducer currentLayout = new TableLayoutProducer(metaData, layout);
        currentLayout.update(pageBox.derive(true), false);
        currentLayout.pageCompleted();
        TableContentProducer contentProducer = new TableContentProducer(layout, metaData);
        contentProducer.compute(pageBox, false);
        return contentProducer;
    }
}

