/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SlimSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;

public class FastSheetLayout
implements SlimSheetLayout {
    private SheetLayout sheetLayout;

    public FastSheetLayout(SheetLayout sheetLayout) {
        this.sheetLayout = sheetLayout.clone();
        this.sheetLayout.clearVerticalInfo();
    }

    public void reinit(long rowHeightOffset, long[] cellHeights) {
        this.sheetLayout.ensureYMapping(0L, false);
        long h = rowHeightOffset;
        for (long height : cellHeights) {
            this.sheetLayout.ensureYMapping(h += height, false);
        }
    }

    @Override
    public long getCellWidth(int col) {
        return this.sheetLayout.getCellWidth(col);
    }

    @Override
    public long getRowHeight(int row) {
        return this.sheetLayout.getRowHeight(row);
    }

    @Override
    public long getXPosition(int col) {
        return this.sheetLayout.getXPosition(col);
    }

    @Override
    public long getYPosition(int row) {
        return this.sheetLayout.getYPosition(row);
    }

    @Override
    public TableRectangle getTableBounds(StrictBounds cb, TableRectangle rectangle) {
        return this.sheetLayout.getTableBounds(cb, rectangle);
    }

    @Override
    public int getColumnCount() {
        return this.sheetLayout.getColumnCount();
    }

    @Override
    public long getCellWidth(int startCell, int endCell) {
        return this.sheetLayout.getCellWidth(startCell, endCell);
    }

    @Override
    public long getMaxWidth() {
        return this.sheetLayout.getMaxWidth();
    }

    public StrictBounds getBounds(TableRectangle rectangle) {
        long x = this.getXPosition(rectangle.getX1());
        long y = this.getYPosition(rectangle.getY1());
        long width = this.getCellWidth(rectangle.getX1(), rectangle.getX2());
        long height = this.sheetLayout.getRowHeight(rectangle.getY1(), rectangle.getY2());
        return new StrictBounds(x, y, width, height);
    }
}

