/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.csv.FastCsvExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.CSVReportUtil;

public class FastCsvReportUtil {
    private FastCsvReportUtil() {
    }

    public static void process(MasterReport report, OutputStream out) throws ReportProcessingException, IOException {
        ReportStructureValidator validator = new ReportStructureValidator();
        if (!validator.isValidForFastProcessing(report)) {
            CSVReportUtil.createCSV(report, out, null);
            return;
        }
        FastCsvExportProcessor reportProcessor = new FastCsvExportProcessor(report, out);
        reportProcessor.processReport();
        reportProcessor.close();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(MasterReport report, OutputStream out, ReportProgressListener listener) throws ReportProcessingException, IOException {
        ReportStructureValidator validator = new ReportStructureValidator();
        if (!validator.isValidForFastProcessing(report)) {
            CSVReportUtil.createCSV(report, out, null, listener);
            return;
        }
        FastCsvExportProcessor reportProcessor = new FastCsvExportProcessor(report, out);
        if (listener != null) {
            reportProcessor.addReportProgressListener(listener);
        }
        try {
            reportProcessor.processReport();
        }
        finally {
            if (listener != null) {
                reportProcessor.removeReportProgressListener(listener);
            }
            reportProcessor.close();
        }
        out.flush();
    }
}

