/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.connections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceMgmtServiceException;

public class SerializedConnection {
    private byte[] connection;

    public SerializedConnection(IDatabaseConnection connection) throws DatasourceMgmtServiceException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(connection);
            out.close();
            this.connection = bout.toByteArray();
        }
        catch (IOException ioe) {
            throw new DatasourceMgmtServiceException(ioe);
        }
    }

    public IDatabaseConnection getConnection() {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.connection);
            ObjectInputStream in = new ObjectInputStream(bin);
            return (IDatabaseConnection)in.readObject();
        }
        catch (IOException e) {
            throw new DatasourceMgmtServiceException("Unable to deserialize database connections.", e);
        }
        catch (ClassNotFoundException e) {
            throw new DatasourceMgmtServiceException("Unable to deserialize database connections.", e);
        }
    }
}

