/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.connections;

import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceServiceException;
import org.pentaho.reporting.libraries.base.boot.SingletonHint;
import org.pentaho.reporting.libraries.base.config.Configuration;

@SingletonHint
public class JndiDataSourceService
implements DataSourceService {
    private static final String JNDI_PREFIX_CONFIGURATION = "org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.jndi-prefix.";
    private static final Log logger = LogFactory.getLog(JndiDataSourceService.class);
    private InitialContext initialContext;

    private synchronized InitialContext getInitialContext() throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext();
        }
        return this.initialContext;
    }

    @Override
    public synchronized void clearCache() {
        this.initialContext = null;
    }

    @Override
    public void clearDataSource(String dsName) {
    }

    @Override
    public DataSource getDataSource(String dsName) throws DatasourceServiceException {
        LookupResult result = this.findDataSource(dsName);
        return result.dataSource;
    }

    @Override
    public String getDSBoundName(String dsName) throws DatasourceServiceException {
        LookupResult result = this.findDataSource(dsName);
        return result.path;
    }

    private LookupResult findDataSource(String connectionPath) throws DatasourceServiceException {
        try {
            InitialContext initialContext = this.getInitialContext();
            Object o = initialContext.lookup(connectionPath);
            if (o instanceof DataSource) {
                LookupResult result = new LookupResult();
                result.dataSource = (DataSource)o;
                result.path = connectionPath;
                return result;
            }
        }
        catch (NamingException e) {
            logger.trace((Object)"Failed to lookup JNDI name", (Throwable)e);
        }
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator keys = config.findPropertyKeys(JNDI_PREFIX_CONFIGURATION);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String prefix = config.getConfigProperty(key);
            try {
                InitialContext initialContext = this.getInitialContext();
                Object o = initialContext.lookup(prefix + connectionPath);
                if (!(o instanceof DataSource)) continue;
                LookupResult result = new LookupResult();
                result.dataSource = (DataSource)o;
                result.path = connectionPath;
                return result;
            }
            catch (NamingException e) {
                logger.trace((Object)"Failed to lookup JNDI name", (Throwable)e);
            }
        }
        throw new DatasourceServiceException("Failed to access the JNDI system: Cannot find the requested datasource '" + connectionPath + "' anywhere in the JNDI system.");
    }

    private static class LookupResult {
        public DataSource dataSource;
        public String path;

        private LookupResult() {
        }
    }
}

