/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.about;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class LibraryPanel
extends JPanel {
    private JTable table;

    public LibraryPanel(List libraries) {
        this.setLayout(new BorderLayout());
        ResourceBundle resources = ResourceBundle.getBundle("org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages");
        Object[] names = new String[]{resources.getString("libraries-table.column.name"), resources.getString("libraries-table.column.version"), resources.getString("libraries-table.column.licence"), resources.getString("libraries-table.column.info")};
        DefaultTableModel model = new DefaultTableModel(names, libraries.size());
        for (int i = 0; i < libraries.size(); ++i) {
            DependencyInformation depInfo = (DependencyInformation)libraries.get(i);
            model.setValueAt(depInfo.getName(), i, 0);
            model.setValueAt(depInfo.getVersion(), i, 1);
            model.setValueAt(depInfo.getLicenseName(), i, 2);
            model.setValueAt(depInfo.getInfo(), i, 3);
        }
        this.table = new JTable(model);
        this.add(new JScrollPane(this.table));
    }

    public LibraryPanel(ProjectInformation projectInfo) {
        this(LibraryPanel.getLibraries(projectInfo));
    }

    private static List getLibraries(ProjectInformation info) {
        if (info == null) {
            return new ArrayList();
        }
        ArrayList libs = new ArrayList();
        LibraryPanel.collectLibraries(info, libs);
        return libs;
    }

    private static void collectLibraries(ProjectInformation info, List list) {
        DependencyInformation lib;
        int i;
        DependencyInformation[] libs = info.getLibraries();
        for (i = 0; i < libs.length; ++i) {
            lib = libs[i];
            if (list.contains(lib)) continue;
            list.add(lib);
            if (!(lib instanceof ProjectInformation)) continue;
            LibraryPanel.collectLibraries((ProjectInformation)lib, list);
        }
        libs = info.getOptionalLibraries();
        for (i = 0; i < libs.length; ++i) {
            lib = libs[i];
            if (list.contains(lib)) continue;
            list.add(lib);
            if (!(lib instanceof ProjectInformation)) continue;
            LibraryPanel.collectLibraries((ProjectInformation)lib, list);
        }
    }

    protected JTable getTable() {
        return this.table;
    }
}

