/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ParameterReportControllerPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;

public class ParameterReportController
implements ReportController {
    private static final Log logger = LogFactory.getLog(ParameterReportController.class);
    private ParameterReportControllerPane controllerPane;
    private PreviewPane previewPane;
    private ReportUpdateHandler reportUpdateHandler = new ReportUpdateHandler();
    private static final JMenu[] EMPTY_MENUS = new JMenu[0];

    public ParameterReportController() {
        this.controllerPane = new ParameterReportControllerPane();
        this.controllerPane.addChangeListener(new ParameterUpdateHandler());
    }

    protected PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    protected ParameterReportControllerPane getControllerPane() {
        return this.controllerPane;
    }

    @Override
    public JComponent getControlPanel() {
        MasterReport report = this.controllerPane.getReport();
        if (report == null) {
            return null;
        }
        ReportParameterDefinition definition = report.getParameterDefinition();
        if (definition == null) {
            return null;
        }
        if (definition.getParameterCount() == 0) {
            return null;
        }
        return this.controllerPane;
    }

    @Override
    public JMenu[] getMenus() {
        return EMPTY_MENUS;
    }

    @Override
    public boolean isInnerComponent() {
        return true;
    }

    @Override
    public String getControllerLocation() {
        return "North";
    }

    @Override
    public void initialize(PreviewPane pane) {
        try {
            if (this.previewPane != null) {
                this.previewPane.removePropertyChangeListener("reportJob", this.reportUpdateHandler);
                this.controllerPane.setReport(null);
            }
            this.previewPane = pane;
            if (this.previewPane != null) {
                this.previewPane.addPropertyChangeListener("reportJob", this.reportUpdateHandler);
                this.controllerPane.setReport(this.previewPane.getReportJob());
            }
        }
        catch (ReportProcessingException e) {
            this.controllerPane.setErrorMessage(e.getMessage());
            logger.debug((Object)"Failed", (Throwable)e);
        }
    }

    @Override
    public void deinitialize(PreviewPane pane) {
        try {
            this.previewPane.removePropertyChangeListener("reportJob", this.reportUpdateHandler);
            this.controllerPane.setReport(null);
        }
        catch (ReportProcessingException e) {
            this.controllerPane.setErrorMessage(e.getMessage());
            logger.debug((Object)"Failed", (Throwable)e);
        }
    }

    private class ReportUpdateHandler
    implements PropertyChangeListener {
        private ReportUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MasterReport report = ParameterReportController.this.getPreviewPane().getReportJob();
            ParameterReportControllerPane reportControllerPane = ParameterReportController.this.getControllerPane();
            try {
                reportControllerPane.setReport(report);
            }
            catch (ReportProcessingException e) {
                reportControllerPane.setErrorMessage(e.getMessage());
                logger.debug((Object)"Failed", (Throwable)e);
            }
        }
    }

    private class ParameterUpdateHandler
    implements ChangeListener {
        private ParameterUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PreviewPane previewPane = ParameterReportController.this.getPreviewPane();
            if (previewPane == null) {
                return;
            }
            ReportParameterValues properties = ParameterReportController.this.getControllerPane().getReportParameterValues();
            MasterReport masterReport = previewPane.getReportJob();
            ReportParameterValues reportParameters = masterReport.getParameterValues();
            String[] strings = properties.getColumnNames();
            for (int i = 0; i < strings.length; ++i) {
                String propertyName = strings[i];
                reportParameters.put(propertyName, properties.get(propertyName));
            }
            previewPane.setReportJob(masterReport);
        }
    }
}

