/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowBlockContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowCanvasContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowContext;

public class WidowContextPool {
    private CanvasContextPool canvasContextPool = new CanvasContextPool();
    private BlockContextPool blockContextPool = new BlockContextPool();

    public WidowContext create(RenderBox box, WidowContext context) {
        if ((box.getLayoutNodeType() & 0x12) == 18) {
            StaticBoxLayoutProperties properties = box.getStaticBoxLayoutProperties();
            int widows = properties.getWidows();
            WidowBlockContext retval = (WidowBlockContext)this.blockContextPool.get();
            retval.init(this.blockContextPool, context, box, widows);
            return retval;
        }
        WidowCanvasContext retval = (WidowCanvasContext)this.canvasContextPool.get();
        retval.init(this.canvasContextPool, context);
        return retval;
    }

    public void free(WidowContext context) {
        context.clearForPooledReuse();
    }

    private static class CanvasContextPool
    extends StackedObjectPool<WidowCanvasContext> {
        private CanvasContextPool() {
        }

        @Override
        protected WidowCanvasContext create() {
            return new WidowCanvasContext();
        }
    }

    private static class BlockContextPool
    extends StackedObjectPool<WidowBlockContext> {
        private BlockContextPool() {
        }

        @Override
        protected WidowBlockContext create() {
            return new WidowBlockContext();
        }
    }
}

