/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BlockLevelPaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.RowLevelPaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;

public class PaginationShiftStatePool {
    private StackedObjectPool<BlockLevelPaginationShiftState> blockPool = new BlockPool();
    private StackedObjectPool<RowLevelPaginationShiftState> rowPool = new RowPool();

    protected boolean isBlock(int nodeType) {
        if ((nodeType & 0x12) == 18) {
            return true;
        }
        if ((nodeType & 0x41002) == 266242) {
            return true;
        }
        if ((nodeType & 0x42002) == 270338) {
            return true;
        }
        return (nodeType & 0x48002) == 294914;
    }

    public PaginationShiftState create(RenderBox box, PaginationShiftState parent) {
        int nodeType = box.getLayoutNodeType();
        if (this.isBlock(nodeType)) {
            BlockLevelPaginationShiftState blockShiftState = this.blockPool.get();
            blockShiftState.reuse(this.blockPool, parent, box);
            return blockShiftState;
        }
        RowLevelPaginationShiftState shiftState = this.rowPool.get();
        shiftState.reuse(this.rowPool, parent, box);
        return shiftState;
    }

    private static class RowPool
    extends StackedObjectPool<RowLevelPaginationShiftState> {
        private RowPool() {
        }

        @Override
        protected RowLevelPaginationShiftState create() {
            return new RowLevelPaginationShiftState();
        }
    }

    private static class BlockPool
    extends StackedObjectPool<BlockLevelPaginationShiftState> {
        private BlockPool() {
        }

        @Override
        protected BlockLevelPaginationShiftState create() {
            return new BlockLevelPaginationShiftState();
        }
    }
}

