/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.FilteringPageBreakPositions;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositions;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BasePaginationTableState;

public class FlowPaginationTableState
implements BasePaginationTableState {
    private FlowPaginationTableState parent;
    private boolean suspended;
    private long pageOffset;
    private PageBreakPositions breakPositions;
    private boolean tableProcessing;

    public FlowPaginationTableState(long pageOffset, PageBreakPositions breakPositions) {
        this.pageOffset = pageOffset;
        this.breakPositions = breakPositions;
    }

    public FlowPaginationTableState(FlowPaginationTableState parent) {
        this.parent = parent;
        this.pageOffset = parent.pageOffset;
        this.breakPositions = parent.breakPositions;
        this.tableProcessing = parent.tableProcessing;
    }

    @Override
    public boolean isTableProcessing() {
        return this.tableProcessing;
    }

    public void suspendVisualStateCollection(boolean temporary) {
        this.suspended = true;
        if (!temporary && this.parent != null) {
            this.parent.suspendVisualStateCollection(temporary);
        }
    }

    @Override
    public long getPageOffset() {
        return this.pageOffset;
    }

    public PageBreakPositions getBreakPositions() {
        return this.breakPositions;
    }

    public boolean isVisualStateCollectionSuspended() {
        return this.suspended;
    }

    public FlowPaginationTableState pop() {
        return this.parent;
    }

    public void defineArtificialPageStart(long offset) {
        this.breakPositions = new FilteringPageBreakPositions(this.breakPositions, offset);
        this.pageOffset = offset;
        this.tableProcessing = true;
    }

    @Override
    public boolean isOnPageStart(long offset) {
        return this.breakPositions.isPageStart(offset);
    }

    @Override
    public long getPageOffset(long position) {
        return this.breakPositions.findPreviousBreakPosition(position);
    }
}

