/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.AlignmentChunk;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.ChunkIterator;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.TextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.util.LongList;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class FastAlignmentProcessor
implements TextAlignmentProcessor {
    private static final long MAX_SIZE = (long)Math.pow(2.0, 50.0);
    private long start;
    private long end;
    private PageGrid breaks;
    private boolean overflowX;
    private long[] pagebreaks = new long[10];
    private ChunkIterator iterator;

    @Override
    public void initialize(OutputProcessorMetaData metaData, SequenceList sequence, long start, long end, PageGrid breaks, boolean overflowX) {
        this.start = start;
        this.end = end;
        this.breaks = breaks;
        this.overflowX = overflowX;
        if (overflowX) {
            this.end = MAX_SIZE;
        }
        this.updateBreaks();
        this.iterator = new ChunkIterator(sequence, 0);
    }

    private void updateBreaks() {
        long[] horizontalBreaks = this.breaks.getHorizontalBreaks();
        int breakCount = horizontalBreaks.length;
        LongList pageLongList = new LongList(breakCount);
        for (int i = 0; i < breakCount - 1; ++i) {
            long pos = horizontalBreaks[i];
            if (pos <= this.start) continue;
            if (!this.overflowX && pos >= this.end) break;
            pageLongList.add(pos);
        }
        pageLongList.add(this.end);
        this.pagebreaks = pageLongList.toArray(this.pagebreaks);
    }

    @Override
    public void updateLineSize(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void deinitialize() {
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    private long calculateWidth(AlignmentChunk chunk, boolean stripFirstSpacer) {
        int chunkEnd = chunk.getEnd();
        boolean first = stripFirstSpacer;
        long length = 0L;
        for (int i = chunk.getStart(); i < chunkEnd; ++i) {
            RenderNode node = chunk.getNode(i);
            InlineSequenceElement sequenceElement = chunk.getSequenceElement(i);
            InlineSequenceElement.Classification classification = sequenceElement.getType();
            if (classification == InlineSequenceElement.Classification.CONTENT) {
                if (first && node.getNodeType() == 65) continue;
                first = false;
            }
            long minimumLength = sequenceElement.getMaximumWidth(node);
            length += minimumLength;
        }
        return length;
    }

    @Override
    public RenderBox next() {
        boolean first = true;
        long posX = this.start;
        RenderBox rootBox = null;
        FastStack context = new FastStack();
        while (this.iterator.hasNext()) {
            AlignmentChunk chunk = this.iterator.next();
            long chunkWidth = this.calculateWidth(chunk, first);
            if (first || posX + chunkWidth < this.end) {
                int chunkEnd = chunk.getEnd();
                for (int i = chunk.getStart(); i < chunkEnd; ++i) {
                    RenderNode node = chunk.getNode(i);
                    InlineSequenceElement sequenceElement = chunk.getSequenceElement(i);
                    InlineSequenceElement.Classification classification = sequenceElement.getType();
                    long minimumLength = sequenceElement.getMaximumWidth(node);
                    if (classification == InlineSequenceElement.Classification.START) {
                        node.setCachedX(posX);
                        RenderBox renderBox = (RenderBox)node.derive(false);
                        context.push((Object)renderBox);
                        if (rootBox == null) {
                            rootBox = renderBox;
                        }
                    } else if (classification == InlineSequenceElement.Classification.END) {
                        RenderBox b = (RenderBox)context.pop();
                        b.setCachedWidth(posX - b.getCachedX() + minimumLength);
                        if (!context.isEmpty()) {
                            ((RenderBox)context.peek()).addGeneratedChild(b);
                        }
                    } else {
                        if (first && node.getNodeType() == 65) continue;
                        RenderNode n = node.derive(true);
                        n.setCachedX(posX);
                        n.setCachedWidth(minimumLength);
                        ((RenderBox)context.peek()).addGeneratedChild(n);
                        first = false;
                    }
                    posX += minimumLength;
                }
                first = false;
                continue;
            }
            int size = context.size();
            ArrayList<RenderBox> paddingBoxes = new ArrayList<RenderBox>(size);
            for (int i = 0; i < size; ++i) {
                RenderBox renderBox = (RenderBox)context.get(i);
                renderBox.setCachedWidth(posX - renderBox.getCachedX());
                RenderBox split = renderBox.split(0);
                paddingBoxes.add(split);
            }
            this.iterator = this.iterator.createPadding(chunk.getStart(), paddingBoxes);
            break;
        }
        return rootBox;
    }
}

