/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.imagemap.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.parser.AreaReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageMapReadHandler
extends AbstractXmlReadHandler {
    private ImageMap imageMap;
    private ArrayList readHandlerArrayList = new ArrayList();

    public ImageMapReadHandler() {
        this.imageMap = new ImageMap();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String name;
            if ("xmlns".equals(attrs.getQName(i)) || attrs.getQName(i).startsWith("xmlns:") || (name = attrs.getLocalName(i)).indexOf(58) > -1) continue;
            String namespace = attrs.getURI(i);
            String attributeValue = attrs.getValue(i);
            if (this.isSameNamespace(namespace) && ("shape".equals(name) || "coords".equals(name))) continue;
            this.imageMap.setAttribute(namespace, name, attributeValue);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("area".equals(tagName)) {
            AreaReadHandler readHandler = new AreaReadHandler();
            this.readHandlerArrayList.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.readHandlerArrayList.size(); ++i) {
            AreaReadHandler readHandler = (AreaReadHandler)((Object)this.readHandlerArrayList.get(i));
            this.imageMap.addMapEntry((ImageMapEntry)readHandler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return this.imageMap;
    }
}

