/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.PageFunction;
import org.pentaho.reporting.engine.classic.core.function.PageTotalFunction;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public class PageOfPagesFunction
extends PageFunction {
    private PageTotalFunction pageTotalFunction = new PageTotalFunction();
    private String format = "{0} / {1}";
    private transient Locale lastLocale;
    private transient Integer lastPage;
    private transient Integer lastTotalPage;
    private transient FastMessageFormat messageFormat;
    private transient String lastMessage;

    public PageOfPagesFunction() {
    }

    public PageOfPagesFunction(String name) {
        this();
        this.setName(name);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        if (format == null) {
            throw new NullPointerException("Format must not be null.");
        }
        this.format = format;
        this.messageFormat = null;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        super.reportInitialized(event);
        this.pageTotalFunction.reportInitialized(event);
    }

    @Override
    public void pageStarted(ReportEvent event) {
        super.pageStarted(event);
        this.pageTotalFunction.pageStarted(event);
    }

    @Override
    public void pageFinished(ReportEvent event) {
        super.pageFinished(event);
        this.pageTotalFunction.pageFinished(event);
    }

    @Override
    public void groupStarted(ReportEvent event) {
        super.groupStarted(event);
        this.pageTotalFunction.groupStarted(event);
    }

    @Override
    public void groupFinished(ReportEvent event) {
        super.groupFinished(event);
        this.pageTotalFunction.groupFinished(event);
    }

    @Override
    public void reportDone(ReportEvent event) {
        super.reportDone(event);
        this.pageTotalFunction.reportDone(event);
    }

    @Override
    public Object getValue() {
        Integer page = (Integer)super.getValue();
        Integer pages = (Integer)this.pageTotalFunction.getValue();
        Locale locale = this.getResourceBundleFactory().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.messageFormat == null || !ObjectUtilities.equal((Object)locale, (Object)this.lastLocale)) {
            this.messageFormat = new FastMessageFormat(this.getFormat(), locale);
            this.lastLocale = locale;
        }
        if (this.lastMessage == null || !ObjectUtilities.equal((Object)page, (Object)this.lastPage) || !ObjectUtilities.equal((Object)pages, (Object)this.lastTotalPage)) {
            this.lastMessage = this.messageFormat.format((Object)new Object[]{page, pages});
            this.lastPage = page;
            this.lastTotalPage = pages;
        }
        return this.lastMessage;
    }

    @Override
    public void setGroup(String group) {
        super.setGroup(group);
        this.pageTotalFunction.setGroup(group);
    }

    @Override
    public void setStartPage(int startPage) {
        super.setStartPage(startPage);
        this.pageTotalFunction.setStartPage(startPage);
    }

    @Override
    public void setDependencyLevel(int level) {
        super.setDependencyLevel(level);
        this.pageTotalFunction.setDependencyLevel(level);
    }

    @Override
    public int getDependencyLevel() {
        return this.pageTotalFunction.getDependencyLevel();
    }

    @Override
    public Expression getInstance() {
        PageOfPagesFunction function = (PageOfPagesFunction)super.getInstance();
        function.pageTotalFunction = (PageTotalFunction)this.pageTotalFunction.getInstance();
        return function;
    }

    @Override
    public void setRuntime(ExpressionRuntime runtime) {
        super.setRuntime(runtime);
        this.pageTotalFunction.setRuntime(runtime);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PageOfPagesFunction function = (PageOfPagesFunction)super.clone();
        function.pageTotalFunction = (PageTotalFunction)this.pageTotalFunction.clone();
        return function;
    }
}

