/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class ItemMaxFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(ItemMaxFunction.class);
    private String group;
    private String field;
    private Sequence<Comparable> max = new Sequence();
    private transient int lastGroupSequenceNumber;
    private String crosstabFilterGroup;

    public ItemMaxFunction() {
    }

    public ItemMaxFunction(String name) {
        this();
        this.setName(name);
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.clear();
    }

    protected void clear() {
        this.lastGroupSequenceNumber = 0;
        this.max.clear();
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.clear();
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String name) {
        this.group = name;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.field == null) {
            return;
        }
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            Comparable oldValue = this.max.get(this.lastGroupSequenceNumber);
            if (oldValue == null || oldValue.compareTo(compare) < 0) {
                this.max.set(this.lastGroupSequenceNumber, compare);
            }
        }
        catch (Exception e) {
            logger.error((Object)"ItemMaxFunction.advanceItems(): problem comparing number.");
        }
    }

    @Override
    public Object getValue() {
        return this.max.get(this.lastGroupSequenceNumber);
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public Expression getInstance() {
        ItemMaxFunction function = (ItemMaxFunction)super.getInstance();
        function.max = this.max.clone();
        function.lastGroupSequenceNumber = 0;
        return function;
    }

    @Override
    public Object clone() {
        try {
            ItemMaxFunction function = (ItemMaxFunction)super.clone();
            function.max = this.max.clone();
            return function;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

