/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import javax.swing.text.Document;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.filter.types.RotatableText;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;

public class TextFieldType
extends AbstractElementType
implements RotatableText {
    public static final ElementType INSTANCE = new TextFieldType();

    public TextFieldType() {
        super("text-field");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue != null) {
            return this.rotate(element, staticValue, runtime);
        }
        Object value = ElementTypeUtils.queryFieldName(element);
        return this.rotate(element, value != null ? value : this.getId(), runtime);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object o = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (o instanceof Document) {
            return this.rotate(element, o, runtime);
        }
        String retval = ElementTypeUtils.toString(o);
        if (retval == null) {
            return this.rotate(element, element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value"), runtime);
        }
        return this.rotate(element, retval, runtime);
    }
}

