/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ExternalElementType
extends AbstractElementType {
    public static final ElementType INSTANCE = new ExternalElementType();
    private static final Log logger = LogFactory.getLog(ExternalElementType.class);

    public ExternalElementType() {
        super("external-element-field");
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue != null) {
            return staticValue;
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Object filteredValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object value = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (value != null && (filteredValue = this.filter(runtime, element, value)) != null) {
            return filteredValue;
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        return this.filter(runtime, element, nullValue);
    }

    private Object filter(ExpressionRuntime runtime, ReportElement element, Object value) {
        if (value instanceof Element) {
            return value;
        }
        try {
            Resource resource;
            Object resourceContent;
            Class target;
            ResourceKey contentBase = runtime.getProcessingContext().getContentBase();
            ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
            Object contentBaseValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
            ResourceKey key = resManager.createOrDeriveKey(contentBase, value, contentBaseValue);
            if (key == null) {
                return null;
            }
            Object targetRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "target-type");
            if (targetRaw instanceof String) {
                ClassLoader loader = ObjectUtilities.getClassLoader(ExternalElementType.class);
                target = Class.forName((String)targetRaw, false, loader);
                if (target == null) {
                    return null;
                }
            } else {
                target = SubReport.class;
            }
            if ((resourceContent = (resource = resManager.create(key, contentBase, target)).getResource()) instanceof Element) {
                return resourceContent;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to load content using value " + value), (Throwable)e);
        }
        return null;
    }
}

