/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model;

public class Query<T> {
    private String name;
    private T query;
    private String queryLanguage;
    private String queryScript;

    public Query(String name, T query) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.query = query;
    }

    public Query(String name, T query, String queryLanguage, String queryScript) {
        this(name, query);
        this.queryLanguage = queryLanguage;
        this.queryScript = queryScript;
    }

    public Query<T> updateName(String name) {
        return new Query<T>(name, this.query, this.queryLanguage, this.queryScript);
    }

    public Query<T> updateQuery(T query) {
        return new Query<T>(this.name, query, this.queryLanguage, this.queryScript);
    }

    public Query<T> updateQueryScript(String queryLanguage, String queryScript) {
        return new Query<T>(this.name, this.query, queryLanguage, queryScript);
    }

    public String getName() {
        return this.name;
    }

    public T getQuery() {
        return this.query;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public String getQueryScript() {
        return this.queryScript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (!this.name.equals(query1.name)) {
            return false;
        }
        if (this.query != null ? !this.query.equals(query1.query) : query1.query != null) {
            return false;
        }
        if (this.queryLanguage != null ? !this.queryLanguage.equals(query1.queryLanguage) : query1.queryLanguage != null) {
            return false;
        }
        return !(this.queryScript != null ? !this.queryScript.equals(query1.queryScript) : query1.queryScript != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
        result = 31 * result + (this.queryScript != null ? this.queryScript.hashCode() : 0);
        return result;
    }
}

