/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import java.util.Date;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public abstract class AbstractDesignTimeDataSchemaModel
implements ContextAwareDataSchemaModel {
    private final AbstractReportDefinition parent;
    private final DataSchemaDefinition dataSchemaDefinition;
    private final DataAttributeContext dataAttributeContext;
    private final MasterReport masterReportElement;

    protected AbstractDesignTimeDataSchemaModel(MasterReport masterReportElement, AbstractReportDefinition report) {
        ArgumentNullException.validate((String)"masterReportElement", (Object)masterReportElement);
        ArgumentNullException.validate((String)"report", (Object)report);
        this.masterReportElement = masterReportElement;
        this.parent = report;
        this.dataSchemaDefinition = this.createDataSchemaDefinition(masterReportElement);
        this.dataAttributeContext = new DefaultDataAttributeContext();
    }

    public DataSchemaDefinition getDataSchemaDefinition() {
        return this.dataSchemaDefinition;
    }

    protected DataSchemaDefinition createDataSchemaDefinition(MasterReport masterReportElement) {
        DataSchemaDefinition dataSchemaDefinition = masterReportElement.getDataSchemaDefinition();
        if (dataSchemaDefinition == null) {
            return DataSchemaUtility.parseDefaults(masterReportElement.getResourceManager());
        }
        return dataSchemaDefinition;
    }

    protected ParameterDataRow computeParameterData() {
        ParameterDataRow parameterRow;
        AbstractReportDefinition parent = this.getReport();
        if (parent instanceof MasterReport) {
            MasterReport mr = (MasterReport)parent;
            LinkedMap values = this.computeParameterValueMap(mr);
            parameterRow = new ParameterDataRow((String[])values.keys((Object[])new String[values.size()]), values.values());
        } else if (parent instanceof SubReport) {
            SubReport sr = (SubReport)parent;
            ParameterMapping[] inputMappings = sr.getInputMappings();
            Object[] values = new Object[inputMappings.length];
            String[] names = new String[inputMappings.length];
            for (int i = 0; i < inputMappings.length; ++i) {
                ParameterMapping inputMapping = inputMappings[i];
                names[i] = inputMapping.getAlias();
            }
            parameterRow = new ParameterDataRow(names, values);
        } else {
            parameterRow = new ParameterDataRow();
        }
        return parameterRow;
    }

    protected ParameterDefinitionEntry[] computeParameterDefinitionEntries() {
        AbstractReportDefinition parent = this.getReport();
        if (parent instanceof MasterReport) {
            MasterReport mr = (MasterReport)parent;
            return mr.getParameterDefinition().getParameterDefinitions();
        }
        return null;
    }

    protected LinkedMap computeParameterValueMap(MasterReport report) {
        LinkedMap retval = new LinkedMap();
        retval.put((Object)"report.date", (Object)new Date());
        ReportParameterValues reportParameterValues = report.getParameterValues();
        ParameterDefinitionEntry[] columnNames = report.getParameterDefinition().getParameterDefinitions();
        for (int i = 0; i < columnNames.length; ++i) {
            ParameterDefinitionEntry parameter = columnNames[i];
            String columnName = parameter.getName();
            if (columnName == null) continue;
            retval.put((Object)columnName, reportParameterValues.get(columnName));
        }
        return retval;
    }

    @Override
    public String[] getColumnNames() {
        return this.getDataSchema().getNames();
    }

    @Override
    public DataAttributeContext getDataAttributeContext() {
        return this.dataAttributeContext;
    }

    protected AbstractReportDefinition getReport() {
        return this.parent;
    }

    protected MasterReport getMasterReportElement() {
        return this.masterReportElement;
    }
}

