/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.engine.classic.core.util.PageSize;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class SimplePageDefinition
implements PageDefinition {
    private transient PageFormat format;
    private transient Rectangle2D[] pagePositions;
    private int pageCountHorizontal;
    private int pageCountVertical;

    public SimplePageDefinition(PageFormat format, int x, int y) {
        if (format == null) {
            throw new NullPointerException("Format must not be null");
        }
        if (x < 1) {
            throw new IllegalArgumentException("PageCount must be greater or equal to 1");
        }
        if (y < 1) {
            throw new IllegalArgumentException("PageCount must be greater or equal to 1");
        }
        this.format = (PageFormat)format.clone();
        this.pageCountHorizontal = x;
        this.pageCountVertical = y;
        this.pagePositions = new Rectangle2D[this.pageCountHorizontal * this.pageCountVertical];
        float width = (float)format.getImageableWidth();
        float height = (float)format.getImageableHeight();
        float pageStartY = 0.0f;
        for (int vert = 0; vert < this.pageCountVertical; ++vert) {
            float pageStartX = 0.0f;
            for (int hor = 0; hor < this.pageCountHorizontal; ++hor) {
                Rectangle2D.Float rect = new Rectangle2D.Float(pageStartX, pageStartY, width, height);
                this.pagePositions[vert * this.pageCountHorizontal + hor] = rect;
                pageStartX += width;
            }
            pageStartY += height;
        }
    }

    public SimplePageDefinition(PageFormat format) {
        this(format, 1, 1);
    }

    public SimplePageDefinition(PageSize papersize, int orientation, Insets margins) {
        this(PageFormatFactory.create(papersize, orientation, margins), 1, 1);
    }

    public SimplePageDefinition(PageSize papersize) {
        this(PageFormatFactory.create(papersize, 1, new Insets(0, 0, 0, 0)), 1, 1);
    }

    @Override
    public int getPageCount() {
        return this.pageCountHorizontal * this.pageCountVertical;
    }

    @Override
    public PageFormat getPageFormat(int pos) {
        if (pos < 0 || pos > this.getPageCount()) {
            throw new IndexOutOfBoundsException("Index is invalid");
        }
        return (PageFormat)this.format.clone();
    }

    @Override
    public Rectangle2D getPagePosition(int index) {
        if (index < 0 || index > this.getPageCount()) {
            throw new IndexOutOfBoundsException("Index is invalid");
        }
        return this.pagePositions[index].getBounds2D();
    }

    @Override
    public Rectangle2D[] getPagePositions() {
        int length = this.pagePositions.length;
        Rectangle2D[] rects = new Rectangle2D[length];
        for (int i = 0; i < length; ++i) {
            rects[i] = this.pagePositions[i].getBounds2D();
        }
        return rects;
    }

    @Override
    public float getHeight() {
        return (float)(this.format.getImageableHeight() * (double)this.pageCountVertical);
    }

    @Override
    public float getWidth() {
        return (float)(this.format.getImageableWidth() * (double)this.pageCountHorizontal);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper instance = SerializerHelper.getInstance();
        instance.writeObject((Object)this.format, out);
        int length = this.pagePositions.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            instance.writeObject((Object)this.pagePositions[i], out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializerHelper instance = SerializerHelper.getInstance();
        this.format = (PageFormat)instance.readObject(in);
        int length = in.readInt();
        this.pagePositions = new Rectangle2D[length];
        for (int i = 0; i < length; ++i) {
            this.pagePositions[i] = (Rectangle2D)instance.readObject(in);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SimplePageDefinition pdef = (SimplePageDefinition)super.clone();
        pdef.format = (PageFormat)this.format.clone();
        return pdef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimplePageDefinition)) {
            return false;
        }
        SimplePageDefinition simplePageDefinition = (SimplePageDefinition)obj;
        if (this.pageCountHorizontal != simplePageDefinition.pageCountHorizontal) {
            return false;
        }
        if (this.pageCountVertical != simplePageDefinition.pageCountVertical) {
            return false;
        }
        if (!PageFormatFactory.isEqual(this.format, simplePageDefinition.format)) {
            return false;
        }
        return Arrays.equals(this.pagePositions, simplePageDefinition.pagePositions);
    }

    public int getPageCountHorizontal() {
        return this.pageCountHorizontal;
    }

    public int getPageCountVertical() {
        return this.pageCountVertical;
    }

    public int hashCode() {
        int result = this.format.hashCode();
        result = 29 * result + this.pageCountHorizontal;
        result = 29 * result + this.pageCountVertical;
        return result;
    }

    public PageFormat getPageFormat() {
        return this.format;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimplePageDefinition");
        sb.append("{format=").append(PageFormatFactory.printPageFormat(this.format));
        sb.append(", pagePositions=").append(this.pagePositions == null ? "null" : Arrays.asList(this.pagePositions).toString());
        sb.append(", pageCountHorizontal=").append(this.pageCountHorizontal);
        sb.append(", pageCountVertical=").append(this.pageCountVertical);
        sb.append('}');
        return sb.toString();
    }
}

