/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentMapping;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class DefaultReportEnvironmentMapping
implements ReportEnvironmentMapping {
    public static final ReportEnvironmentMapping INSTANCE = new DefaultReportEnvironmentMapping();
    private static final String ENV_MAPPING_KEY_PREFIX = "org.pentaho.reporting.engine.classic.core.env-mapping.";
    private Map<String, String> cachedEnvironmentMapping;

    public DefaultReportEnvironmentMapping() {
        this.preComputeEnvironmentMapping();
    }

    @Override
    public Map<String, String> createEnvironmentMapping() {
        return this.cachedEnvironmentMapping;
    }

    private void preComputeEnvironmentMapping() {
        if (this.cachedEnvironmentMapping == null) {
            Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
            Iterator propertyKeys = configuration.findPropertyKeys(ENV_MAPPING_KEY_PREFIX);
            LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
            while (propertyKeys.hasNext()) {
                String key = (String)propertyKeys.next();
                String value = configuration.getConfigProperty(key);
                String shortKey = key.substring(ENV_MAPPING_KEY_PREFIX.length());
                names.put(shortKey, value);
            }
            this.cachedEnvironmentMapping = Collections.unmodifiableMap(names);
        }
    }
}

