/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.general.DefaultPieDataset;
import org.pentaho.plugin.jfreereport.reportcharts.ICollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class PieSetCollectorFunction
extends AbstractFunction
implements ICollectorFunction {
    private static final long serialVersionUID = -5778788510651234706L;
    private int currentIndex;
    private DefaultPieDataset pieDataset;
    private List results = new ArrayList();
    private String seriesColumn;
    private String valueColumn;
    private String group;
    private String resetGroup;
    private boolean summaryOnly;

    public String getSeriesColumn() {
        return this.seriesColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public String getResetGroup() {
        return this.resetGroup;
    }

    public void setSeriesColumn(String value) {
        this.seriesColumn = value;
    }

    public void setValueColumn(String value) {
        this.valueColumn = value;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public void setResetGroup(String value) {
        this.resetGroup = value;
    }

    public boolean isSummaryOnly() {
        return this.summaryOnly;
    }

    public void setSummaryOnly(boolean value) {
        this.summaryOnly = value;
    }

    @Override
    public Object getValue() {
        return this;
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            this.pieDataset = null;
            this.results.clear();
            if (this.getResetGroup() == null) {
                this.pieDataset = new DefaultPieDataset();
                this.results.add(this.pieDataset);
            }
        } else if (this.getResetGroup() == null && this.results.size() > 0) {
            this.pieDataset = (DefaultPieDataset)this.results.get(0);
        }
    }

    public void groupStarted(ReportEvent event) {
        String localGroup = this.getGroup();
        if (localGroup != null && FunctionUtilities.isDefinedGroup((String)this.getResetGroup(), (ReportEvent)event)) {
            if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
                this.pieDataset = new DefaultPieDataset();
                this.results.add(this.pieDataset);
            } else if (FunctionUtilities.isLayoutLevel((ReportEvent)event)) {
                ++this.currentIndex;
                this.pieDataset = (DefaultPieDataset)this.results.get(this.currentIndex);
            }
        }
    }

    public void itemsAdvanced(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        DefaultPieDataset localPieDataset = this.pieDataset;
        if (!this.isSummaryOnly()) {
            Object seriesObject = this.getDataRow().get(this.getSeriesColumn());
            Object seriesComparable = seriesObject instanceof Comparable ? (Comparable)seriesObject : "PIESETCOLL.USER_ERROR_CATEGORY_NOT_COMPARABLE";
            Object valueObject = this.getDataRow().get(this.getValueColumn());
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            Number isThere = null;
            try {
                isThere = localPieDataset.getValue((Comparable)seriesComparable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isThere != null) {
                double val = value != null ? value.doubleValue() : 0.0;
                value = new Double(val + isThere.doubleValue());
            }
            localPieDataset.setValue((Comparable)seriesComparable, value);
        }
    }

    public void groupFinished(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        DefaultPieDataset localPieDataset = this.pieDataset;
        if (this.isSummaryOnly() && FunctionUtilities.isDefinedGroup((String)this.getGroup(), (ReportEvent)reportEvent)) {
            Object seriesObject = this.getDataRow().get(this.getSeriesColumn());
            Object seriesComparable = seriesObject instanceof Comparable ? (Comparable)seriesObject : "PIESETCOLL.USER_ERROR_SERIES_NOT_COMPARABLE";
            Object valueObject = this.getDataRow().get(this.getValueColumn());
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            localPieDataset.setValue((Comparable)seriesComparable, value);
        }
    }

    public Expression getInstance() {
        PieSetCollectorFunction fn = (PieSetCollectorFunction)super.getInstance();
        fn.pieDataset = null;
        fn.results = new ArrayList();
        fn.currentIndex = 0;
        return fn;
    }

    @Override
    public Object getCacheKey() {
        return this.pieDataset;
    }

    @Override
    public Object getDatasourceValue() {
        return this.pieDataset;
    }
}

