/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.pentaho.plugin.jfreereport.reportcharts.BubbleRenderer;
import org.pentaho.plugin.jfreereport.reportcharts.ExtendedXYZDataset;
import org.pentaho.plugin.jfreereport.reportcharts.XYChartExpression;

public class BubbleChartExpression
extends XYChartExpression {
    private static final long serialVersionUID = 7934486966108227105L;
    private double maxBubbleSize = 0.0;
    private String bubbleLabelContent = "{0}: ({1}, {2}, {3})";
    private String xFormat = "";
    private String yFormat = "";
    private String zFormat = "";

    @Override
    protected JFreeChart computeXYChart(XYDataset dataset) {
        double maxZValue;
        ExtendedXYZDataset xyzDataset;
        if (dataset instanceof ExtendedXYZDataset) {
            ExtendedXYZDataset exyzDataset;
            xyzDataset = exyzDataset = (ExtendedXYZDataset)dataset;
            maxZValue = exyzDataset.getMaxZValue();
        } else if (dataset instanceof XYZDataset) {
            xyzDataset = (XYZDataset)dataset;
            maxZValue = this.precomputeMaxZ((XYZDataset)xyzDataset);
        } else {
            xyzDataset = null;
            maxZValue = 0.0;
        }
        JFreeChart rtn = ChartFactory.createBubbleChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYZDataset)xyzDataset, (PlotOrientation)this.computePlotOrientation(), (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        BubbleRenderer renderer = new BubbleRenderer();
        renderer.setMaxSize(this.getMaxBubbleSize());
        renderer.setMaxZ(maxZValue);
        rtn.getXYPlot().setRenderer((XYItemRenderer)renderer);
        this.configureLogarithmicAxis(rtn.getXYPlot());
        return rtn;
    }

    private double precomputeMaxZ(XYZDataset dataset) {
        double retval = Double.MIN_VALUE;
        for (int series = 0; series < dataset.getSeriesCount(); ++series) {
            int itemcount = dataset.getItemCount(series);
            for (int item = 0; item < itemcount; ++item) {
                double value = dataset.getZValue(series, item);
                if (!(retval < value)) continue;
                retval = value;
            }
        }
        return retval;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
    }

    public double getMaxBubbleSize() {
        return this.maxBubbleSize;
    }

    public void setMaxBubbleSize(double maxBubbleSize) {
        this.maxBubbleSize = maxBubbleSize;
    }

    public String getBubbleLabelContent() {
        return this.bubbleLabelContent;
    }

    public void setBubbleLabelContent(String bubbleLabelContent) {
        this.bubbleLabelContent = bubbleLabelContent;
    }

    public String getXFormat() {
        return this.xFormat;
    }

    public void setXFormat(String format) {
        this.xFormat = format;
    }

    public String getYFormat() {
        return this.yFormat;
    }

    public void setYFormat(String format) {
        this.yFormat = format;
    }

    public String getZFormat() {
        return this.zFormat;
    }

    public void setZFormat(String format) {
        this.zFormat = format;
    }

    public double getMaxZValue() {
        return 0.0;
    }
}

