/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.ICollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public abstract class BaseCollectorFunction
extends AbstractFunction
implements ICollectorFunction {
    protected static final Log logger = LogFactory.getLog(BaseCollectorFunction.class);
    private Dataset dataset;
    private String group;
    private String resetGroup;
    private ArrayList results;
    private ArrayList seriesNames = new ArrayList();
    private int currentIndex;
    private boolean summaryOnly = false;
    private boolean seriesColumn = false;
    private ReportStateKey processKey;

    protected BaseCollectorFunction() {
        this.results = new ArrayList();
    }

    public void setSeriesName(int index, String field) {
        if (this.seriesNames.size() == index) {
            this.seriesNames.add(field);
        } else {
            this.seriesNames.set(index, field);
        }
    }

    public String getSeriesName(int index) {
        return (String)this.seriesNames.get(index);
    }

    public int getSeriesNameCount() {
        return this.seriesNames.size();
    }

    public String[] getSeriesName() {
        return this.seriesNames.toArray(new String[this.seriesNames.size()]);
    }

    public void setSeriesName(String[] fields) {
        this.seriesNames.clear();
        this.seriesNames.addAll(Arrays.asList(fields));
    }

    protected Dataset createNewDataset() {
        return this.getNewDataset();
    }

    public boolean isSummaryOnly() {
        return this.summaryOnly;
    }

    public void setSummaryOnly(boolean value) {
        this.summaryOnly = value;
    }

    public boolean isSeriesColumn() {
        return this.seriesColumn;
    }

    public void setSeriesColumn(boolean value) {
        this.seriesColumn = value;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getResetGroup() {
        return this.resetGroup;
    }

    public void setResetGroup(String resetGroup) {
        this.resetGroup = resetGroup;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public Object getDatasourceValue() {
        return this.dataset;
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (this.processKey == null) {
            this.processKey = event.getState().getProcessKey();
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            this.dataset = null;
            this.results.clear();
            if (this.getResetGroup() == null) {
                this.dataset = this.createNewDataset();
                this.results.add(this.dataset);
            }
        } else if (this.getResetGroup() == null && !this.results.isEmpty()) {
            this.dataset = (AbstractDataset)this.results.get(0);
        }
    }

    public void groupStarted(ReportEvent event) {
        String localGroup = this.getGroup();
        if (localGroup == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedGroup((String)this.getResetGroup(), (ReportEvent)event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            this.dataset = this.createNewDataset();
            this.results.add(this.dataset);
        } else if (FunctionUtilities.isLayoutLevel((ReportEvent)event)) {
            ++this.currentIndex;
            this.dataset = (AbstractDataset)this.results.get(this.currentIndex);
        }
    }

    public Expression getInstance() {
        BaseCollectorFunction fn = (BaseCollectorFunction)super.getInstance();
        fn.dataset = null;
        fn.processKey = null;
        fn.results = new ArrayList();
        fn.seriesNames = (ArrayList)this.seriesNames.clone();
        return fn;
    }

    @Override
    public Object getCacheKey() {
        return new CacheKey(this.processKey, this.currentIndex);
    }

    public AbstractDataset getNewDataset() {
        return null;
    }

    private static class CacheKey {
        private int index;
        private ReportStateKey stateKey;

        private CacheKey(ReportStateKey stateKey, int index) {
            this.stateKey = stateKey;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.index != cacheKey.index) {
                return false;
            }
            return !(this.stateKey != null ? !this.stateKey.equals((Object)cacheKey.stateKey) : cacheKey.stateKey != null);
        }

        public int hashCode() {
            int result = this.index;
            result = 31 * result + (this.stateKey != null ? this.stateKey.hashCode() : 0);
            return result;
        }
    }
}

