/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.pentaho.plugin.jfreereport.reportcharts.StackedCategoricalChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FormattedCategoryAxis;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FormattedCategoryAxis3D;

public class BarChartExpression
extends StackedCategoricalChartExpression {
    private static final long serialVersionUID = 7082583397390897215L;
    private Double maxBarWidth;
    private boolean stackedBarRenderPercentages;
    private Double itemMargin;
    private boolean shadowVisible;
    private Color shadowColor;
    private int shadowXOffset;
    private int shadowYOffset;

    public Double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(Double itemMargin) {
        this.itemMargin = itemMargin;
    }

    public Double getMaxBarWidth() {
        return this.maxBarWidth;
    }

    public void setMaxBarWidth(Double value) {
        this.maxBarWidth = value;
    }

    public boolean isStackedBarRenderPercentages() {
        return this.stackedBarRenderPercentages;
    }

    public void setStackedBarRenderPercentages(boolean value) {
        this.stackedBarRenderPercentages = value;
    }

    @Override
    public JFreeChart computeCategoryChart(CategoryDataset categoryDataset) {
        JFreeChart chart;
        PlotOrientation orientation = this.computePlotOrientation();
        if (this.isThreeD()) {
            chart = this.isStacked() ? ChartFactory.createStackedBarChart3D((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false) : ChartFactory.createBarChart3D((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
            chart.getCategoryPlot().setDomainAxis((CategoryAxis)new FormattedCategoryAxis3D(this.getCategoryAxisLabel(), this.getCategoricalAxisMessageFormat(), this.getRuntime().getResourceBundleFactory().getLocale()));
        } else {
            chart = this.isStacked() ? ChartFactory.createStackedBarChart((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false) : ChartFactory.createBarChart((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
            chart.getCategoryPlot().setDomainAxis((CategoryAxis)new FormattedCategoryAxis(this.getCategoryAxisLabel(), this.getCategoricalAxisMessageFormat(), this.getRuntime().getResourceBundleFactory().getLocale()));
        }
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        this.configureLogarithmicAxis(plot);
        return chart;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        CategoryPlot cpl = chart.getCategoryPlot();
        CategoryItemRenderer renderer = cpl.getRenderer();
        BarRenderer br = (BarRenderer)renderer;
        if (this.isAutoRange()) {
            br.setIncludeBaseInRange(false);
        }
        super.configureChart(chart);
        br.setDrawBarOutline(this.isChartSectionOutline());
        if (this.maxBarWidth != null) {
            br.setMaximumBarWidth(this.maxBarWidth.doubleValue());
        }
        if (this.itemMargin != null) {
            br.setItemMargin(this.itemMargin.doubleValue());
        }
        if (this.isStacked() && this.stackedBarRenderPercentages && br instanceof StackedBarRenderer) {
            StackedBarRenderer sbr = (StackedBarRenderer)br;
            sbr.setRenderAsPercentages(true);
        }
        br.setShadowVisible(this.shadowVisible);
        if (this.shadowColor != null) {
            br.setShadowPaint((Paint)this.shadowColor);
        }
        br.setShadowXOffset((double)this.shadowXOffset);
        br.setShadowYOffset((double)this.shadowYOffset);
    }

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setShadowVisible(boolean shadowVisible) {
        this.shadowVisible = shadowVisible;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    public int getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(int shadowXOffset) {
        this.shadowXOffset = shadowXOffset;
    }

    public int getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(int shadowYOffset) {
        this.shadowYOffset = shadowYOffset;
    }

    public boolean isDrawBarOutline() {
        return this.isChartSectionOutline();
    }

    public void setDrawBarOutline(boolean value) {
        this.setChartSectionOutline(value);
    }
}

