/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.protocol.HttpContext;

public class HttpKerberosRequestInterceptor
extends HttpRequestInterceptorBase {
    String principal;
    String host;
    String serverHttpUrl;
    boolean assumeSubject;
    private static ReentrantLock kerberosLock = new ReentrantLock(true);

    public HttpKerberosRequestInterceptor(String principal, String host, String serverHttpUrl, boolean assumeSubject, CookieStore cs, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        super(cs, cn, isSSL, additionalHeaders, customCookies);
        this.principal = principal;
        this.host = host;
        this.serverHttpUrl = serverHttpUrl;
        this.assumeSubject = assumeSubject;
    }

    @Override
    protected void addHttpAuthHeader(HttpRequest httpRequest, HttpContext httpContext) throws Exception {
        try {
            kerberosLock.lock();
            String kerberosAuthHeader = HttpAuthUtils.getKerberosServiceTicket((String)this.principal, (String)this.host, (String)this.serverHttpUrl, (boolean)this.assumeSubject);
            httpRequest.addHeader("Authorization: Negotiate ", kerberosAuthHeader);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
        finally {
            kerberosLock.unlock();
        }
    }
}

