/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.context.support;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OsgiBundleXmlWebApplicationContext
extends OsgiBundleXmlApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    private static final String APPLICATION_CONTEXT_SERVICE_NAMESPACE_PROPERTY = "org.springframework.web.context.namespace";
    public static final String BUNDLE_CONTEXT_ATTRIBUTE = "org.springframework.osgi.web." + BundleContext.class.getName();
    private static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    private String namespace;
    private ThemeSource themeSource;

    public OsgiBundleXmlWebApplicationContext() {
        this.setDisplayName("Root OsgiWebApplicationContext");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        if (this.getBundleContext() == null) {
            ApplicationContext parent;
            Object context;
            if (servletContext != null && (context = servletContext.getAttribute(BUNDLE_CONTEXT_ATTRIBUTE)) != null) {
                Assert.isInstanceOf((Class)BundleContext.class, (Object)context);
                this.logger.debug((Object)("Using the bundle context located in the servlet context at " + BUNDLE_CONTEXT_ATTRIBUTE));
                this.setBundleContext((BundleContext)context);
            }
            if ((parent = this.getParent()) instanceof ConfigurableOsgiBundleApplicationContext) {
                this.logger.debug((Object)"Using the application context parent's bundle context");
                this.setBundleContext(((ConfigurableOsgiBundleApplicationContext)parent).getBundleContext());
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null) {
            if (this.servletContext == null) {
                this.setServletContext(servletConfig.getServletContext());
            }
            if (this.getNamespace() == null) {
                this.setNamespace(this.servletConfig.getServletName() + DEFAULT_NAMESPACE_SUFFIX);
            }
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.postProcessBeanFactory(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.ignoreDependencyInterface(ServletConfigAware.class);
        beanFactory.registerResolvableDependency(ServletContext.class, (Object)this.servletContext);
        beanFactory.registerResolvableDependency(ServletConfig.class, (Object)this.servletConfig);
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)beanFactory);
    }

    protected void customizeApplicationContextServiceProperties(Map serviceProperties) {
        super.customizeApplicationContextServiceProperties(serviceProperties);
        String ns = this.getNamespace();
        if (ns != null) {
            serviceProperties.put(APPLICATION_CONTEXT_SERVICE_NAMESPACE_PROPERTY, ns);
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    protected String[] getDefaultConfigLocations() {
        String ns = this.getNamespace();
        if (ns != null) {
            return new String[]{"/WEB-INF/" + ns + ".xml"};
        }
        return new String[]{"/WEB-INF/applicationContext.xml"};
    }

    public void setConfigLocation(String location) {
        this.setConfigLocations(StringUtils.tokenizeToStringArray((String)location, (String)",; \t\n"));
    }
}

