/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.AbstractLValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class ContextLookup
extends AbstractLValue {
    private String name;
    private static final long serialVersionUID = 2882834743999159722L;

    public ContextLookup(String name) {
        this(name, null);
    }

    public ContextLookup(String name, ParsePosition parsePosition) {
        this.name = name;
        this.setParsePosition(parsePosition);
    }

    @Override
    public TypeValuePair evaluate() throws EvaluationException {
        FormulaContext context = this.getContext();
        Type type = context.resolveReferenceType(this.name);
        Object value = context.resolveReference(this.name);
        if (value == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        return new TypeValuePair(type, value);
    }

    @Override
    public Type getValueType() {
        try {
            FormulaContext context = this.getContext();
            return context.resolveReferenceType(this.name);
        }
        catch (EvaluationException evalex) {
            return ErrorType.TYPE;
        }
    }

    public String toString() {
        return FormulaUtil.quoteReference(this.name);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public String getName() {
        return this.name;
    }
}

