/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.userroledao.jackrabbit.security;

import javax.jcr.SimpleCredentials;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.pentaho.platform.engine.security.messages.Messages;
import org.pentaho.platform.util.StringUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.encoding.PasswordEncoder;

public class DefaultPentahoPasswordEncoder
implements PasswordEncoder {
    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        Validate.notNull((Object)rawPass, (String)Messages.getInstance().getString("DefaultPentahoPasswordEncoder.ERROR_0001_RAWPASS_CANNOT_BE_NULL"));
        if (StringUtil.isEmpty((String)rawPass)) {
            return rawPass;
        }
        try {
            CryptedSimpleCredentials cryptedCredentials = new CryptedSimpleCredentials(new SimpleCredentials("dummyUser", rawPass.toCharArray()));
            return cryptedCredentials.getPassword();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        try {
            Validate.notNull((Object)encPass, (String)Messages.getInstance().getString("DefaultPentahoPasswordEncoder.ERROR_0002_ENCPASS_CANNOT_BE_NULL"));
            Validate.notNull((Object)rawPass, (String)Messages.getInstance().getString("DefaultPentahoPasswordEncoder.ERROR_0001_RAWPASS_CANNOT_BE_NULL"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            CryptedSimpleCredentials credentials = new CryptedSimpleCredentials("dummyUser", encPass);
            return credentials.matches(new SimpleCredentials("dummyUser", rawPass.toCharArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

