/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.IRepositoryVersionManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.webservices.LocaleMapDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclAceDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.api.repository2.unified.webservices.StringKeyStringValueDto;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.webservices.DateAdapter;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFileAdapter
extends XmlAdapter<RepositoryFileDto, RepositoryFile> {
    private static Logger logger = LoggerFactory.getLogger(RepositoryFileAdapter.class);
    private static DefaultUnifiedRepositoryWebService repoWs;
    private Set<String> membersSet;
    private boolean exclude;
    private boolean includeAcls;

    public RepositoryFileAdapter() {
        this.exclude = false;
        this.includeAcls = false;
        this.membersSet = null;
    }

    public RepositoryFileAdapter(RepositoryRequest repositoryRequest) {
        if (repositoryRequest.getExcludeMemberSet() != null && !repositoryRequest.getExcludeMemberSet().isEmpty()) {
            this.exclude = true;
            this.membersSet = repositoryRequest.getExcludeMemberSet();
        } else {
            this.exclude = false;
            this.membersSet = repositoryRequest.getIncludeMemberSet();
        }
        this.includeAcls = repositoryRequest.isIncludeAcls();
    }

    public static Logger getLogger() {
        return logger;
    }

    public RepositoryFileDto marshal(RepositoryFile v) {
        return RepositoryFileAdapter.toFileDto(v, this.membersSet, this.exclude, this.includeAcls);
    }

    public RepositoryFileDto marshal(RepositoryFileTree repositoryFileTree) {
        return RepositoryFileAdapter.toFileDto(repositoryFileTree, this.membersSet, this.exclude, this.includeAcls);
    }

    private static boolean include(String key, Set<String> set, boolean exclude) {
        return !exclude && (set == null || set.contains(key)) || exclude && !set.contains(key);
    }

    public static RepositoryFileDto toFileDto(RepositoryFileTree repositoryFileTree, Set<String> memberSet, boolean exclude, boolean includeAcls) {
        RepositoryFileDto repositoryFileDto = RepositoryFileAdapter.toFileDto(repositoryFileTree.getFile(), memberSet, exclude, includeAcls);
        return repositoryFileDto;
    }

    public static RepositoryFileDto toFileDto(RepositoryFile v, Set<String> memberSet, boolean exclude) {
        return RepositoryFileAdapter.toFileDto(v, memberSet, exclude, false);
    }

    public static RepositoryFileDto toFileDto(RepositoryFile v, Set<String> memberSet, boolean exclude, boolean includeAcls) {
        IRepositoryVersionManager repositoryVersionManager;
        if (v == null) {
            return null;
        }
        RepositoryFileDto f = new RepositoryFileDto();
        try {
            if (RepositoryFileAdapter.include("name", memberSet, exclude)) {
                f.setName(v.getName());
            }
            if (RepositoryFileAdapter.include("path", memberSet, exclude)) {
                f.setPath(v.getPath());
            }
            if (RepositoryFileAdapter.include("hidden", memberSet, exclude)) {
                f.setHidden(v.isHidden().booleanValue());
            }
            if (RepositoryFileAdapter.include("aclNode", memberSet, exclude)) {
                f.setAclNode(v.isAclNode());
            }
            if (RepositoryFileAdapter.include("createDate", memberSet, exclude)) {
                f.setCreatedDate(RepositoryFileAdapter.marshalDate(v.getCreatedDate()));
            }
            if (RepositoryFileAdapter.include("creatorId", memberSet, exclude)) {
                f.setCreatorId(v.getCreatorId());
            }
            if (RepositoryFileAdapter.include("fileSize", memberSet, exclude)) {
                f.setFileSize(v.getFileSize().longValue());
            }
            if (RepositoryFileAdapter.include("description", memberSet, exclude)) {
                f.setDescription(v.getDescription());
            }
            if (RepositoryFileAdapter.include("folder", memberSet, exclude)) {
                f.setFolder(v.isFolder());
            }
            if (v.getId() != null) {
                f.setId(v.getId().toString());
            }
            if (RepositoryFileAdapter.include("lastModifiedDate", memberSet, exclude)) {
                f.setLastModifiedDate(RepositoryFileAdapter.marshalDate(v.getLastModifiedDate()));
            }
            if (RepositoryFileAdapter.include("locale", memberSet, exclude)) {
                f.setLocale(v.getLocale());
            }
            if (RepositoryFileAdapter.include("originalParentFolderPath", memberSet, exclude)) {
                f.setOriginalParentFolderPath(v.getOriginalParentFolderPath());
            }
            if (RepositoryFileAdapter.include("deletedDate", memberSet, exclude)) {
                f.setDeletedDate(RepositoryFileAdapter.marshalDate(v.getDeletedDate()));
            }
            if (RepositoryFileAdapter.include("lockDate", memberSet, exclude)) {
                f.setLockDate(RepositoryFileAdapter.marshalDate(v.getLockDate()));
            }
            if (RepositoryFileAdapter.include("locked", memberSet, exclude)) {
                f.setLocked(v.isLocked());
            }
            if (RepositoryFileAdapter.include("lockMessage", memberSet, exclude)) {
                f.setLockMessage(v.getLockMessage());
            }
            if (RepositoryFileAdapter.include("lockOwner", memberSet, exclude)) {
                f.setLockOwner(v.getLockOwner());
            }
            if (RepositoryFileAdapter.include("title", memberSet, exclude)) {
                f.setTitle(v.getTitle());
            }
            if (RepositoryFileAdapter.include("versioned", memberSet, exclude)) {
                f.setVersioned(v.isVersioned());
            }
            if (RepositoryFileAdapter.include("versionId", memberSet, exclude) && v.getVersionId() != null) {
                f.setVersionId(v.getVersionId().toString());
            }
        }
        catch (NullPointerException e) {
            RepositoryFileAdapter.getLogger().warn("NullPointerException while reading file attributes, returning null. Probable cause: File does notexist anymore: ");
            return null;
        }
        if (includeAcls) {
            RepositoryFileAclDto acl;
            Iterator id;
            if (v.getId() != null) {
                try {
                    id = v.getId().toString();
                    f.setRepositoryFileAclDto(RepositoryFileAdapter.getRepoWs().getAcl((String)((Object)id)));
                    if (f.getRepositoryFileAclDto().isEntriesInheriting()) {
                        List<RepositoryFileAclAceDto> aces = RepositoryFileAdapter.getRepoWs().getEffectiveAces((String)((Object)id));
                        f.getRepositoryFileAclDto().setAces(aces, f.getRepositoryFileAclDto().isEntriesInheriting());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (RepositoryFileAdapter.include("owner", memberSet, exclude) && (id = v.getId()) != null && (acl = RepositoryFileAdapter.getRepoWs().getAcl("" + id)) != null) {
                f.setOwner(acl.getOwner());
            }
        }
        if (RepositoryFileAdapter.include("locales", memberSet, exclude) && v.getLocalePropertiesMap() != null) {
            f.setLocalePropertiesMapEntries(new ArrayList());
            for (Map.Entry entry : v.getLocalePropertiesMap().entrySet()) {
                LocaleMapDto localeMapDto = new LocaleMapDto();
                ArrayList<StringKeyStringValueDto> valuesDto = new ArrayList<StringKeyStringValueDto>();
                Properties properties = (Properties)entry.getValue();
                if (properties != null) {
                    for (String propertyName : properties.stringPropertyNames()) {
                        valuesDto.add(new StringKeyStringValueDto(propertyName, properties.getProperty(propertyName)));
                    }
                }
                localeMapDto.setLocale((String)entry.getKey());
                localeMapDto.setProperties(valuesDto);
                f.getLocalePropertiesMapEntries().add(localeMapDto);
            }
        }
        try {
            repositoryVersionManager = JcrRepositoryFileUtils.getRepositoryVersionManager();
            if (repositoryVersionManager == null) {
                return f;
            }
        }
        catch (NoClassDefFoundError ex) {
            return f;
        }
        if (RepositoryFileAdapter.include("versioningEnabled", memberSet, exclude)) {
            f.setVersioningEnabled(Boolean.valueOf(repositoryVersionManager.isVersioningEnabled(v.getPath())));
        }
        if (RepositoryFileAdapter.include("versionCommentEnabled", memberSet, exclude)) {
            f.setVersionCommentEnabled(Boolean.valueOf(repositoryVersionManager.isVersionCommentEnabled(v.getPath())));
        }
        return f;
    }

    public RepositoryFile unmarshal(RepositoryFileDto v) {
        return RepositoryFileAdapter.toFile(v);
    }

    public static RepositoryFile toFile(RepositoryFileDto v) {
        if (v == null) {
            return null;
        }
        RepositoryFile.Builder builder = null;
        builder = v.getId() != null ? new RepositoryFile.Builder((Serializable)((Object)v.getId()), v.getName()) : new RepositoryFile.Builder(v.getName());
        if (v.getOwnerType() != -1) {
            new RepositoryFileSid(v.getOwner(), RepositoryFileSid.Type.values()[v.getOwnerType()]);
        }
        if (v.getLocalePropertiesMapEntries() != null) {
            for (LocaleMapDto localeMapDto : v.getLocalePropertiesMapEntries()) {
                String locale = localeMapDto.getLocale();
                Properties localeProperties = new Properties();
                if (localeMapDto.getProperties() != null) {
                    for (StringKeyStringValueDto keyValueDto : localeMapDto.getProperties()) {
                        localeProperties.put(keyValueDto.getKey(), keyValueDto.getValue());
                    }
                }
                builder.localeProperties(locale, localeProperties);
            }
        }
        return builder.path(v.getPath()).createdDate(RepositoryFileAdapter.unmarshalDate(v.getCreatedDate())).creatorId(v.getCreatorId()).description(v.getDescription()).folder(v.isFolder()).fileSize(v.getFileSize()).lastModificationDate(RepositoryFileAdapter.unmarshalDate(v.getLastModifiedDate())).locale(v.getLocale()).lockDate(RepositoryFileAdapter.unmarshalDate(v.getLockDate())).locked(v.isLocked()).lockMessage(v.getLockMessage()).lockOwner(v.getLockOwner()).title(v.getTitle()).versioned(v.isVersioned()).versionId((Serializable)((Object)v.getVersionId())).originalParentFolderPath(v.getOriginalParentFolderPath()).deletedDate(RepositoryFileAdapter.unmarshalDate(v.getDeletedDate())).hidden(v.isHidden()).schedulable(!v.isNotSchedulable()).aclNode(v.isAclNode()).build();
    }

    public static Date unmarshalDate(String date) {
        DateAdapter adapter = new DateAdapter();
        if (date == null || date.length() == 0) {
            return null;
        }
        try {
            return adapter.unmarshal(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String marshalDate(Date date) {
        DateAdapter adapter = new DateAdapter();
        if (date == null) {
            return "";
        }
        try {
            return adapter.marshal(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DefaultUnifiedRepositoryWebService getRepoWs() {
        if (repoWs == null) {
            repoWs = new DefaultUnifiedRepositoryWebService();
        }
        return repoWs;
    }
}

