/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclAceDto;

public class RepositoryFileAclAceAdapter
extends XmlAdapter<RepositoryFileAclAceDto, RepositoryFileAce> {
    public RepositoryFileAclAceDto marshal(RepositoryFileAce v) {
        return RepositoryFileAclAceAdapter.toAceDto(v);
    }

    public static RepositoryFileAclAceDto toAceDto(RepositoryFileAce v) {
        RepositoryFileAclAceDto aceDto = new RepositoryFileAclAceDto();
        RepositoryFileSid sid = v.getSid();
        aceDto.setRecipient(sid.getName());
        aceDto.setRecipientType(sid.getType().ordinal());
        aceDto.setPermissions(RepositoryFileAclAceAdapter.toIntPerms(v.getPermissions()));
        return aceDto;
    }

    public RepositoryFileAce unmarshal(RepositoryFileAclAceDto v) {
        return RepositoryFileAclAceAdapter.toAce(v);
    }

    public static RepositoryFileAce toAce(RepositoryFileAclAceDto v) {
        return new RepositoryFileAce(new RepositoryFileSid(v.getRecipient(), RepositoryFileSid.Type.values()[v.getRecipientType()]), RepositoryFileAclAceAdapter.toPerms(v.getPermissions()));
    }

    public static List<Integer> toIntPerms(EnumSet<RepositoryFilePermission> perms) {
        ArrayList<Integer> intPerms = new ArrayList<Integer>();
        if (perms != null) {
            for (RepositoryFilePermission perm : perms) {
                intPerms.add(perm.ordinal());
            }
        }
        return intPerms;
    }

    public static EnumSet<RepositoryFilePermission> toPerms(List<Integer> intPerms) {
        ArrayList<RepositoryFilePermission> perms = new ArrayList<RepositoryFilePermission>();
        if (intPerms != null) {
            for (int intPerm : intPerms) {
                perms.add(RepositoryFilePermission.values()[intPerm]);
            }
        }
        return EnumSet.copyOf(perms);
    }
}

