/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.util.Arrays;
import java.util.List;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.jcr.IPentahoInternalPrincipal;

public class PentahoMetadataAcePrincipal
implements IPentahoInternalPrincipal {
    public static final String PRINCIPAL_PREFIX = "org.pentaho.jcr";
    public static final char SEPARATOR = ':';
    private static final List<Character> RESERVED_CHARS = Arrays.asList(Character.valueOf(':'));
    private final boolean entriesInheriting;
    private final String owner;
    private final String encodedName;

    public PentahoMetadataAcePrincipal(String owner, boolean entriesInheriting) {
        this.owner = owner;
        this.entriesInheriting = entriesInheriting;
        this.encodedName = "org.pentaho.jcr:" + RepositoryFilenameUtils.escape(owner, RESERVED_CHARS) + ':' + entriesInheriting;
    }

    @Override
    public String getName() {
        return this.encodedName;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public static boolean isPentahoMetadataAcePrincipal(String name) {
        return name.startsWith("org.pentaho.jcr:");
    }
}

