/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;

public class NodeHelper {
    protected static boolean checkHasNode(Node parentNode, String nodeName) throws RepositoryException {
        return parentNode.hasNode(nodeName);
    }

    public static boolean hasNode(Node parentNode, String nodeNamePrefix, String nodeName) throws RepositoryException {
        return NodeHelper.checkHasNode(parentNode, nodeNamePrefix + JcrStringHelper.fileNameEncode(nodeName));
    }

    protected static Node checkAddNode(Node parentNode, String nodeName) throws RepositoryException {
        return parentNode.addNode(nodeName);
    }

    public static Node addNode(Node parentNode, String nodeNamePrefix, String nodeName) throws RepositoryException {
        return NodeHelper.checkAddNode(parentNode, nodeNamePrefix + JcrStringHelper.fileNameEncode(nodeName));
    }

    public static Node addNode(Node parentNode, String nodeNamePrefix, String nodeName, String nodeParameter) throws RepositoryException {
        return NodeHelper.checkAddNode(parentNode, nodeNamePrefix + JcrStringHelper.fileNameEncode(nodeName), nodeParameter);
    }

    protected static Node checkAddNode(Node parentNode, String nodeName, String nodeParameter) throws RepositoryException {
        return parentNode.addNode(nodeName, nodeParameter);
    }

    protected static Node checkGetNode(Node parentNode, String nodeName) throws RepositoryException {
        return parentNode.getNode(nodeName);
    }

    public static Node getNode(Node parentNode, String nodeNamePrefix, String nodeName) throws RepositoryException {
        return NodeHelper.checkGetNode(parentNode, nodeNamePrefix + JcrStringHelper.fileNameEncode(nodeName));
    }

    public static DataNode createDataNode(String name) {
        return new DataNode(JcrStringHelper.fileNameEncode(name));
    }
}

