/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.webservices;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.repository.webservices.DatabaseConnectionAdapter;
import org.pentaho.platform.repository.webservices.DatabaseConnectionDto;
import org.pentaho.platform.repository.webservices.IDatasourceMgmtWebService;

public class DatasourceMgmtToWebServiceAdapter
implements IDatasourceMgmtService {
    private IDatasourceMgmtWebService datasourceMgmtWebService;
    private DatabaseConnectionAdapter databaseConnectionAdapter = new DatabaseConnectionAdapter();

    public DatasourceMgmtToWebServiceAdapter(IDatasourceMgmtWebService datasourceMgmtWebService) {
        this.datasourceMgmtWebService = datasourceMgmtWebService;
    }

    public void init(IPentahoSession session) {
    }

    public String createDatasource(IDatabaseConnection databaseConnection) {
        try {
            return this.datasourceMgmtWebService.createDatasource(this.databaseConnectionAdapter.marshal((DatabaseConnection)databaseConnection));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteDatasourceByName(String name) {
        this.datasourceMgmtWebService.deleteDatasourceByName(name);
    }

    public IDatabaseConnection getDatasourceByName(String name) {
        try {
            return this.databaseConnectionAdapter.unmarshal(this.datasourceMgmtWebService.getDatasourceByName(name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<IDatabaseConnection> getDatasources() {
        ArrayList<IDatabaseConnection> databaseConnections = new ArrayList<IDatabaseConnection>();
        for (DatabaseConnectionDto databaseConnection : this.datasourceMgmtWebService.getDatasources()) {
            try {
                databaseConnections.add((IDatabaseConnection)this.databaseConnectionAdapter.unmarshal(databaseConnection));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return databaseConnections;
    }

    public String updateDatasourceByName(String name, IDatabaseConnection databaseConnection) {
        try {
            return this.datasourceMgmtWebService.updateDatasourceByName(name, this.databaseConnectionAdapter.marshal((DatabaseConnection)databaseConnection));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteDatasourceById(String id) {
        this.datasourceMgmtWebService.deleteDatasourceById(id);
    }

    public IDatabaseConnection getDatasourceById(String id) {
        try {
            return this.databaseConnectionAdapter.unmarshal(this.datasourceMgmtWebService.getDatasourceById(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getDatasourceIds() {
        return this.datasourceMgmtWebService.getDatasourceIds();
    }

    public String updateDatasourceById(String id, IDatabaseConnection databaseConnection) {
        try {
            return this.datasourceMgmtWebService.updateDatasourceById(id, this.databaseConnectionAdapter.marshal((DatabaseConnection)databaseConnection));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

