/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.legacy.acl;

import java.util.ArrayList;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IAclVoter;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoter;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.pentaho.platform.repository.legacy.acl.LegacyRepositoryFile;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

@Deprecated
public class AccessVoterToLegacyAcl
implements IRepositoryAccessVoter {
    private IAclVoter aclVoter;

    public AccessVoterToLegacyAcl(IAclVoter aclVoter) {
        Assert.notNull((Object)aclVoter);
        this.aclVoter = aclVoter;
    }

    public boolean hasAccess(RepositoryFile file, RepositoryFilePermission operation, RepositoryFileAcl acl, IPentahoSession session) {
        Assert.notNull((Object)file);
        Assert.notNull((Object)operation);
        Assert.notNull((Object)acl);
        return this.aclVoter.hasAccess(session, (IAclHolder)this.convert(file, acl), this.mask(operation));
    }

    private int mask(RepositoryFilePermission permission) {
        Assert.notNull((Object)permission);
        if (RepositoryFilePermission.READ == permission) {
            return 1;
        }
        if (RepositoryFilePermission.WRITE == permission) {
            return 12;
        }
        if (RepositoryFilePermission.DELETE == permission) {
            return 16;
        }
        if (RepositoryFilePermission.ACL_MANAGEMENT == permission) {
            return 32;
        }
        if (RepositoryFilePermission.ALL == permission) {
            return -1;
        }
        return 0;
    }

    private LegacyRepositoryFile convert(RepositoryFile file, RepositoryFileAcl acl) {
        LegacyRepositoryFile legacy = new LegacyRepositoryFile(file.getName(), file.getPath(), file.isFolder());
        legacy.setId(file.getId());
        if (file.getLastModifiedDate() != null) {
            legacy.setLastModified(file.getLastModifiedDate().getTime());
        }
        ArrayList<IPentahoAclEntry> legacyAcls = new ArrayList<IPentahoAclEntry>();
        for (RepositoryFileAce fileAce : acl.getAces()) {
            if (fileAce == null || fileAce.getSid() == null || fileAce.getPermissions() == null) continue;
            for (RepositoryFilePermission filePermission : fileAce.getPermissions()) {
                PentahoAclEntry fileAcl = new PentahoAclEntry();
                if (RepositoryFileSid.Type.USER == fileAce.getSid().getType()) {
                    fileAcl.setRecipient((Object)fileAce.getSid().getName());
                } else {
                    fileAcl.setRecipient((Object)new SimpleGrantedAuthority(fileAce.getSid().getName()));
                }
                fileAcl.setMask(this.mask(filePermission));
                legacyAcls.add((IPentahoAclEntry)fileAcl);
            }
        }
        legacy.setAccessControls(legacyAcls);
        return legacy;
    }
}

