/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IRuntimeElement;
import org.pentaho.platform.api.repository.IRuntimeRepository;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.services.runtime.SimpleRuntimeElement;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.UUIDUtil;

public class SimpleRuntimeRepository
extends PentahoBase
implements IRuntimeRepository {
    private static final long serialVersionUID = -6093228119094501691L;
    private static final boolean debug = true;
    private static final Log log = LogFactory.getLog(SimpleRuntimeRepository.class);
    private static final ThreadLocal threadSession = new ThreadLocal();

    public static IPentahoSession getUserSession() {
        IPentahoSession userSession = (IPentahoSession)threadSession.get();
        return userSession;
    }

    public List getMessages() {
        return null;
    }

    public void setSession(IPentahoSession sess) {
        threadSession.set(sess);
        this.genLogIdFromSession(SimpleRuntimeRepository.getUserSession());
    }

    public IRuntimeElement loadElementById(String instanceId, Collection allowableReadAttributeNames) throws RepositoryException {
        this.debug(Messages.getInstance().getString("RTREPO.DEBUG_CREATE_INSTANCE", new Object[]{instanceId}));
        SimpleRuntimeElement re = new SimpleRuntimeElement(instanceId);
        return re;
    }

    public IRuntimeElement newRuntimeElement(String parId, String parType, boolean transientOnly) {
        this.debug(Messages.getInstance().getString("RTREPO.DEBUG_NEW_ELEMENT_PARENT", new Object[]{parId, parType}));
        String instanceId = UUIDUtil.getUUIDAsString();
        this.debug(Messages.getInstance().getString("RTREPO.DEBUG_CREATE_INSTANCE", new Object[]{instanceId}));
        SimpleRuntimeElement re = new SimpleRuntimeElement(instanceId, parId, parType);
        return re;
    }

    public IRuntimeElement newRuntimeElement(String parId, String parType, String solnId, boolean transientOnly) {
        this.debug(Messages.getInstance().getString("RTREPO.DEBUG_NEW_ELEMENT_PARENT_SOLN", new Object[]{parId, parType, solnId}));
        String instanceId = UUIDUtil.getUUIDAsString();
        this.debug(Messages.getInstance().getString("RTREPO.DEBUG_CREATE_INSTANCE", new Object[]{instanceId}));
        SimpleRuntimeElement re = new SimpleRuntimeElement(instanceId, parId, parType, solnId);
        return re;
    }

    public Log getLogger() {
        return log;
    }

    public boolean usesHibernate() {
        return false;
    }

    public void exitPoint() {
    }
}

