/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessControlException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.launch.Framework;

class ShutdownSocketThread
extends Thread {
    Logger LOG = Logger.getLogger(this.getClass().getName());
    private final String shutdown;
    private Random random = null;
    private ServerSocket shutdownSocket;
    private Framework framework;

    public ShutdownSocketThread(String shutdown, ServerSocket shutdownSocket, Framework framework) {
        this.shutdown = shutdown;
        this.shutdownSocket = shutdownSocket;
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                int expected;
                Socket socket = null;
                InputStream stream = null;
                long acceptStartTime = System.currentTimeMillis();
                try {
                    socket = this.shutdownSocket.accept();
                    socket.setSoTimeout(10000);
                    stream = socket.getInputStream();
                }
                catch (SocketTimeoutException ste) {
                    this.LOG.log(Level.WARNING, "Karaf shutdown socket: The socket listening for the shutdown command experienced an unexpected timeout [" + (System.currentTimeMillis() - acceptStartTime) + "] milliseconds " + "after the call to accept(). Is this an instance of bug 3325?", ste);
                    continue;
                }
                catch (AccessControlException ace) {
                    this.LOG.log(Level.WARNING, "Karaf shutdown socket: security exception: " + ace.getMessage(), ace);
                    continue;
                }
                catch (IOException e) {
                    this.LOG.log(Level.SEVERE, "Karaf shutdown socket: accept: ", e);
                    System.exit(1);
                }
                StringBuilder command = new StringBuilder();
                for (expected = 1024; expected < this.shutdown.length(); expected += this.random.nextInt() % 1024) {
                    if (this.random != null) continue;
                    this.random = new Random();
                }
                while (expected > 0) {
                    int ch;
                    try {
                        ch = stream.read();
                    }
                    catch (IOException e) {
                        this.LOG.log(Level.WARNING, "Karaf shutdown socket:  read: ", e);
                        ch = -1;
                    }
                    if (ch < 32) break;
                    command.append((char)ch);
                    --expected;
                }
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                boolean match = command.toString().equals(this.shutdown);
                if (match) {
                    this.LOG.log(Level.INFO, "Karaf shutdown socket: received shutdown command. Stopping framework...");
                    this.framework.stop();
                    break;
                }
                this.LOG.log(Level.WARNING, "Karaf shutdown socket:  Invalid command '" + command.toString() + "' received");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.shutdownSocket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

