/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.model.entities.serialization;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.marketplace.domain.model.entities.DevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.MarketEntryType;
import org.pentaho.marketplace.domain.model.entities.interfaces.ICategory;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.entities.serialization.IMarketplaceXmlSerializer;
import org.pentaho.marketplace.domain.model.factories.interfaces.ICategoryFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.pentaho.marketplace.util.XmlParserFactoryProducer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MarketplaceXmlSerializer
implements IMarketplaceXmlSerializer {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String OSGI_URL_SUFFIX = ".kar";
    private IPluginFactory pluginFactory;
    private IPluginVersionFactory pluginVersionFactory;
    private ICategoryFactory categoryFactory;
    private Log logger = LogFactory.getLog(this.getClass());
    private DocumentBuilderFactory documentBuilderFactory;
    private XPath xpath;

    private Log getLogger() {
        return this.logger;
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public MarketplaceXmlSerializer(IPluginFactory pluginFactory, IPluginVersionFactory pluginVersionFactory, ICategoryFactory categoryFactory) {
        this.pluginFactory = pluginFactory;
        this.pluginVersionFactory = pluginVersionFactory;
        this.categoryFactory = categoryFactory;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.documentBuilderFactory = this.createDocumentBuilderFactory();
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory secureDocBuilderFactory = null;
        try {
            secureDocBuilderFactory = XmlParserFactoryProducer.createSecureDocBuilderFactory();
        }
        catch (ParserConfigurationException e) {
            this.getLogger().error((Object)e);
        }
        return secureDocBuilderFactory;
    }

    @Override
    public Map<String, IPlugin> getPlugins(InputStream xmlStream) {
        Map<String, IPlugin> plugins = Collections.emptyMap();
        try {
            DocumentBuilder db = this.getDocumentBuilderFactory().newDocumentBuilder();
            Document document = db.parse(xmlStream);
            plugins = this.getPlugins(document);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error getting plugins from marketplace xml.", (Throwable)e);
        }
        return plugins;
    }

    @Override
    public Map<String, IPlugin> getPlugins(String xml) {
        Map<String, IPlugin> plugins = Collections.emptyMap();
        try {
            DocumentBuilder db = this.getDocumentBuilderFactory().newDocumentBuilder();
            Document document = db.parse(new InputSource(new StringReader(xml)));
            plugins = this.getPlugins(document);
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Error getting plugins from marketplace xml: " + xml), (Throwable)e);
        }
        return plugins;
    }

    @Override
    public Map<String, IPlugin> getPlugins(Document marketplaceMetadataDocument) throws XPathExpressionException {
        NodeList plugins = marketplaceMetadataDocument.getElementsByTagName("market_entry");
        HashMap<String, IPlugin> pluginMap = new HashMap<String, IPlugin>();
        for (int i = 0; i < plugins.getLength(); ++i) {
            Element pluginElement = (Element)plugins.item(i);
            IPlugin plugin = this.getPlugin(pluginElement);
            pluginMap.put(plugin.getId(), plugin);
        }
        return pluginMap;
    }

    private IPlugin getPlugin(Element pluginElement) throws XPathExpressionException {
        IPlugin plugin = (IPlugin)this.pluginFactory.create();
        plugin.setId(this.getElementChildValue(pluginElement, "id"));
        plugin.setName(this.getElementChildValue(pluginElement, "name"));
        plugin.setDescription(this.getElementChildValue(pluginElement, "description"));
        plugin.setAuthorName(this.getElementChildValue(pluginElement, "author"));
        plugin.setAuthorUrl(this.getElementChildValue(pluginElement, "author_url"));
        plugin.setAuthorLogo(this.getElementChildValue(pluginElement, "author_logo"));
        plugin.setImg(this.getElementChildValue(pluginElement, "img"));
        plugin.setSmallImg(this.getElementChildValue(pluginElement, "small_img"));
        plugin.setDocumentationUrl(this.getElementChildValue(pluginElement, "documentation_url"));
        plugin.setInstallationNotes(this.getElementChildValue(pluginElement, "installation_notes"));
        plugin.setLicense(this.getElementChildValue(pluginElement, "license"));
        plugin.setLicenseName(this.getElementChildValue(pluginElement, "license_name"));
        plugin.setLicenseText(this.getElementChildValue(pluginElement, "license_text"));
        plugin.setDependencies(this.getElementChildValue(pluginElement, "dependencies"));
        plugin.setType(MarketEntryType.valueOf(this.getElementChildValue(pluginElement, "type")));
        plugin.setCategory(this.getCategory(pluginElement));
        NodeList availableVersionsNode = (NodeList)this.xpath.evaluate("versions/version", pluginElement, XPathConstants.NODESET);
        Collection<IPluginVersion> versions = this.getPluginVersions(availableVersionsNode);
        plugin.setVersions(versions);
        NodeList availableScreenshotsNode = (NodeList)this.xpath.evaluate("screenshots/screenshot", pluginElement, XPathConstants.NODESET);
        String[] screenshots = this.getScreenshots(availableScreenshotsNode);
        plugin.setScreenshots(screenshots);
        return plugin;
    }

    private IPluginVersion getPluginVersion(Element versionElement) throws XPathExpressionException {
        IPluginVersion version = (IPluginVersion)this.pluginVersionFactory.create();
        version.setBranch(this.getElementChildValue(versionElement, "branch"));
        version.setName(this.getElementChildValue(versionElement, "name"));
        version.setVersion(this.getElementChildValue(versionElement, "version"));
        String downloadUrl = this.getElementChildValue(versionElement, "package_url");
        if (downloadUrl != null) {
            downloadUrl = downloadUrl.trim();
            version.setDownloadUrl(downloadUrl);
            version.setIsOsgi(downloadUrl.endsWith(OSGI_URL_SUFFIX));
        }
        version.setSamplesDownloadUrl(this.getElementChildValue(versionElement, "samples_url"));
        version.setDescription(this.getElementChildValue(versionElement, "description"));
        version.setChangelog(this.getElementChildValue(versionElement, "changelog"));
        version.setBuildId(this.getElementChildValue(versionElement, "build_id"));
        version.setReleaseDate(this.getElementChildValue(versionElement, "releaseDate"));
        version.setMinParentVersion(this.getElementChildValue(versionElement, "min_parent_version"));
        version.setMaxParentVersion(this.getElementChildValue(versionElement, "max_parent_version"));
        version.setDevelopmentStage(this.getDevelopmentStage(versionElement));
        return version;
    }

    private Collection<IPluginVersion> getPluginVersions(NodeList versionsElement) throws XPathExpressionException {
        if (versionsElement.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IPluginVersion> versions = new ArrayList<IPluginVersion>();
        for (int j = 0; j < versionsElement.getLength(); ++j) {
            Element versionElement = (Element)versionsElement.item(j);
            IPluginVersion pv = this.getPluginVersion(versionElement);
            versions.add(pv);
        }
        return versions;
    }

    private String[] getScreenshots(NodeList screenshotsElement) {
        if (screenshotsElement.getLength() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] screenshots = new String[screenshotsElement.getLength()];
        for (int j = 0; j < screenshotsElement.getLength(); ++j) {
            Element screenshotElement = (Element)screenshotsElement.item(j);
            screenshots[j] = screenshotElement.getTextContent();
        }
        return screenshots;
    }

    private String getElementChildValue(Element element, String child) throws XPathExpressionException {
        Element childElement = (Element)this.xpath.evaluate(child, element, XPathConstants.NODE);
        if (childElement != null) {
            return childElement.getTextContent();
        }
        return null;
    }

    private ICategory getCategory(Element pluginElement) throws XPathExpressionException {
        String CATEGORY_ELEMENT_NAME = "category";
        Element categoryElement = (Element)this.xpath.evaluate("category", pluginElement, XPathConstants.NODE);
        if (categoryElement == null) {
            return null;
        }
        return this.getCategoryFromCategoryElement(categoryElement);
    }

    private ICategory getCategoryFromCategoryElement(Element categoryElement) throws XPathExpressionException {
        String PARENT_ELEMENT_NAME = "parent";
        String NAME_ELEMENT_NAME = "name";
        ICategory parent = null;
        Element parentElement = (Element)this.xpath.evaluate("parent", categoryElement, XPathConstants.NODE);
        if (parentElement != null) {
            parent = this.getCategoryFromCategoryElement(parentElement);
        }
        String name = this.getElementChildValue(categoryElement, "name");
        ICategory category = this.categoryFactory.create(name, parent);
        return category;
    }

    private IDevelopmentStage getDevelopmentStage(Element versionElement) throws XPathExpressionException {
        String DEVELOPMENT_STAGE_ELEMENT_NAME = "development_stage";
        String DEVELOPMENT_STAGE_LANE_ELEMENT_NAME = "lane";
        String DEVELOPMENT_STAGE_PHASE_ELEMENT_NAME = "phase";
        Element devStageElement = (Element)this.xpath.evaluate("development_stage", versionElement, XPathConstants.NODE);
        if (devStageElement == null) {
            return null;
        }
        String lane = this.getElementChildValue(devStageElement, "lane");
        String phase = this.getElementChildValue(devStageElement, "phase");
        return new DevelopmentStage(lane, phase);
    }

    @Override
    public IPluginVersion getInstalledVersion(String xml) {
        return this.getInstalledVersion(new InputSource(new StringReader(xml)));
    }

    @Override
    public IPluginVersion getInstalledVersion(InputSource inputDocument) {
        IPluginVersion version = null;
        try {
            DocumentBuilder db = this.getDocumentBuilderFactory().newDocumentBuilder();
            Document document = db.parse(inputDocument);
            version = this.getInstalledVersion(document);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error getting plugin version from version xml.", (Throwable)e);
        }
        return version;
    }

    @Override
    public IPluginVersion getInstalledVersion(Document installedVersionDocument) {
        NodeList versionElements = installedVersionDocument.getElementsByTagName("version");
        if (versionElements.getLength() == 0) {
            return null;
        }
        Element versionElement = (Element)versionElements.item(0);
        IPluginVersion version = (IPluginVersion)this.pluginVersionFactory.create();
        version.setBranch(versionElement.getAttribute("branch"));
        version.setVersion(versionElement.getTextContent());
        version.setBuildId(versionElement.getAttribute("buildId"));
        return version;
    }
}

