/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import com.google.common.base.Throwables;
import java.io.DataInputStream;
import java.sql.SQLException;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultHeader;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultSet;

public class ThinResultFactory {
    public ThinResultSet loadResultSet(DataInputStream dataInputStream, IDataServiceClientService client) throws SQLException {
        return new ThinResultSet(this.loadHeader(dataInputStream), dataInputStream, client);
    }

    public ThinResultHeader loadHeader(DataInputStream dataInputStream) throws SQLException {
        try {
            String serviceName = dataInputStream.readUTF();
            String serviceTransName = dataInputStream.readUTF();
            String serviceObjectId = dataInputStream.readUTF();
            String sqlTransName = dataInputStream.readUTF();
            String sqlObjectId = dataInputStream.readUTF();
            if (!KettleClientEnvironment.isInitialized()) {
                KettleClientEnvironment.init();
            }
            RowMeta rowMeta = new RowMeta(dataInputStream);
            return new ThinResultHeader(serviceName, serviceTransName, serviceObjectId, sqlTransName, sqlObjectId, (RowMetaInterface)rowMeta);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SQLException.class);
            throw new SQLException("Unable to load result set", e);
        }
    }
}

