/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="money")
public class Money
extends ExtensionPoint {
    static final String XML_NAME = "money";
    private static final String AMOUNT = "amount";
    private static final String CURRENCYCODE = "currencyCode";
    private Double amount = null;
    private String currencyCode = null;

    public Money() {
    }

    public Money(Double amount, String currencyCode) {
        this.setAmount(amount);
        this.setCurrencyCode(currencyCode);
        this.setImmutable(true);
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.throwExceptionIfImmutable();
        this.amount = amount;
    }

    public boolean hasAmount() {
        return this.getAmount() != null;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.throwExceptionIfImmutable();
        this.currencyCode = currencyCode;
    }

    public boolean hasCurrencyCode() {
        return this.getCurrencyCode() != null;
    }

    protected void validate() {
        if (this.amount == null) {
            Money.throwExceptionForMissingAttribute((String)AMOUNT);
        }
        if (this.currencyCode == null) {
            Money.throwExceptionForMissingAttribute((String)CURRENCYCODE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Money.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(AMOUNT, (Object)this.amount);
        generator.put((Object)CURRENCYCODE, (Object)this.currencyCode);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.amount = helper.consumeDouble(AMOUNT, true);
        this.currencyCode = helper.consume(CURRENCYCODE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Money other = (Money)((Object)obj);
        return Money.eq((Object)this.amount, (Object)other.amount) && Money.eq((Object)this.currencyCode, (Object)other.currencyCode);
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().hashCode();
        if (this.amount != null) {
            result = 37 * result + this.amount.hashCode();
        }
        if (this.currencyCode != null) {
            result = 37 * result + this.currencyCode.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Money amount=" + this.amount + " currencyCode=" + this.currencyCode + "}";
    }
}

