/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.CatalogComponentHelper;
import org.apache.camel.commands.internal.RegexUtil;

public class CatalogComponentInfoCommand
extends AbstractCamelCommand {
    private static final String[][] COMPONENT_PROPERTIES = new String[][]{{"Property", "Description"}, {"key", "description"}};
    private static final String[][] COMPONENT_PROPERTIES_VERBOSE = new String[][]{{"Property", "Description"}, {"key", "description"}};
    private static final String[][] PROPERTIES = new String[][]{{"Property", "Description"}, {"key", "description"}};
    private static final String[][] PROPERTIES_VERBOSE = new String[][]{{"Property", "Group", "Default Value", "Description"}, {"key", "group", "defaultValue", "description"}};
    private final String name;
    private final boolean verbose;
    private final String labelFilter;

    public CatalogComponentInfoCommand(String name, boolean verbose, String labelFilter) {
        this.name = name;
        this.verbose = verbose;
        this.labelFilter = labelFilter != null ? RegexUtil.wildcardAsRegex(labelFilter) : null;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        Map<String, Object> info = camelController.componentInfo(this.name);
        String component = this.name.toUpperCase();
        if (info.containsKey("description")) {
            component = component + " :: " + info.get("description");
        }
        out.println("");
        out.println(component);
        out.println(CatalogComponentInfoCommand.buildSeparatorString(component.length(), '-'));
        out.println("");
        if (info.containsKey("label")) {
            out.printf("label: %s\n", info.get("label"));
        }
        if (info.containsKey("groupId") && info.containsKey("artifactId") && info.containsKey("version")) {
            out.printf("maven: %s\n", info.get("groupId") + "/" + info.get("artifactId") + "/" + info.get("version"));
        }
        this.dumpProperties("componentProperties", info, this.verbose ? COMPONENT_PROPERTIES_VERBOSE : COMPONENT_PROPERTIES, out);
        this.dumpProperties("properties", info, this.verbose ? PROPERTIES_VERBOSE : PROPERTIES, out);
        return null;
    }

    private void dumpProperties(String groupName, Map<String, Object> info, String[][] tableStruct, PrintStream out) {
        Map group = (Map)info.get(groupName);
        if (group != null) {
            CatalogComponentHelper.Table table = new CatalogComponentHelper.Table(tableStruct[0], tableStruct[1]);
            for (Map.Entry entry : group.entrySet()) {
                Map data;
                if (!(entry.getValue() instanceof Map) || !this.matchLabel(data = (Map)entry.getValue())) continue;
                table.addRow((String)entry.getKey(), data);
            }
            if (!table.isEmpty()) {
                out.println("");
                out.println(groupName);
                out.println("");
                table.print(out);
            }
        }
    }

    private static String buildSeparatorString(int len, char pad) {
        StringBuilder sb = new StringBuilder(len);
        while (sb.length() < len) {
            sb.append(pad);
        }
        return sb.toString();
    }

    private boolean matchLabel(Map<String, Object> properties) {
        if (this.labelFilter == null) {
            return true;
        }
        String label = (String)properties.get("label");
        if (label != null) {
            String[] parts;
            for (String part : parts = label.split(",")) {
                try {
                    if (part.equalsIgnoreCase(this.labelFilter) || CatalogHelper.matchWildcard((String)part, (String)this.labelFilter) || part.matches(this.labelFilter)) {
                        return true;
                    }
                }
                catch (PatternSyntaxException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

