/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.toc;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerDocumentContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.toc.Messages;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.extensions.toc.IndexElement;

public class EditIndexAction
extends AbstractElementSelectionAction {
    public EditIndexAction() {
        this.putValue("Name", Messages.getInstance().getString("EditIndexAction.Text"));
        this.putValue("ShortDescription", Messages.getInstance().getString("EditIndexAction.Description"));
        this.putValue("MnemonicKey", Messages.getInstance().getOptionalMnemonic("EditIndexAction.Mnemonic"));
        this.putValue("AcceleratorKey", Messages.getInstance().getOptionalKeyStroke("EditIndexAction.Accelerator"));
    }

    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = this.getSelectionModel().getSelectedElement(0);
        if (selectedElement instanceof IndexElement) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext designerContext = this.getReportDesignerContext();
        if (designerContext == null) {
            return;
        }
        ReportDocumentContext activeReportContext = this.getActiveContext();
        if (activeReportContext == null) {
            return;
        }
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        Object leadSelection = selectionModel1.getLeadSelection();
        if (!(leadSelection instanceof Element)) {
            return;
        }
        Element element = (Element)leadSelection;
        if (element instanceof IndexElement) {
            int contextCount = designerContext.getReportRenderContextCount();
            for (int i = 0; i < contextCount; ++i) {
                ReportRenderContext rrc = designerContext.getReportRenderContext(i);
                if (rrc.getReportDefinition() != element) continue;
                designerContext.setActiveDocument((ReportDesignerDocumentContext)rrc);
                return;
            }
            IndexElement report = (IndexElement)element;
            try {
                designerContext.addSubReport(activeReportContext, (SubReport)report);
            }
            catch (ReportDataFactoryException e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
            }
        }
    }
}

