/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.HttpClientManager;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryBackend;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaResponseParser;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class HttpQueryBackend
extends CdaQueryBackend {
    private static final char DOMAIN_SEPARATOR = '\\';
    private transient HttpClient client;
    private volatile transient HttpGet httpCall;

    @Override
    public TypedTableModel fetchData(DataRow dataRow, String method, Map<String, String> extraParameter) throws ReportDataFactoryException {
        String baseURL = this.getBaseUrl();
        if (StringUtils.isEmpty((String)baseURL, (boolean)true)) {
            throw new ReportDataFactoryException("Base URL is null");
        }
        String url = this.createURL(method, extraParameter);
        try {
            HttpGet httpCall;
            this.httpCall = httpCall = new HttpGet(url);
            HttpClient client = this.getHttpClient();
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpCall);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new ReportDataFactoryException("Failed to retrieve data: " + httpResponse.getStatusLine());
            }
            InputStream responseBody = httpResponse.getEntity().getContent();
            TypedTableModel typedTableModel = CdaResponseParser.performParse(responseBody);
            return typedTableModel;
        }
        catch (UnsupportedEncodingException use) {
            throw new ReportDataFactoryException("Failed to encode parameter", (Throwable)use);
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed to send request : " + url, (Throwable)e);
        }
        finally {
            this.httpCall = null;
        }
    }

    @Override
    public void cancelRunningQuery() {
        HttpGet method = this.httpCall;
        if (method != null) {
            method.abort();
        }
    }

    protected HttpClient getHttpClient() {
        if (this.client == null) {
            HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
            this.client = clientBuilder.setCredentials(this.getUsername(), this.getPassword()).setCookieSpec("default").build();
        }
        return this.client;
    }

    public static Credentials getCredentials(String user, String password) {
        if (StringUtils.isEmpty((String)user)) {
            return null;
        }
        int domainIdx = user.indexOf(92);
        if (domainIdx == -1) {
            return new UsernamePasswordCredentials(user, password);
        }
        try {
            String domain = user.substring(0, domainIdx);
            String username = user.substring(domainIdx + 1);
            String host = InetAddress.getLocalHost().getHostName();
            return new NTCredentials(username, password, host, domain);
        }
        catch (UnknownHostException uhe) {
            return new UsernamePasswordCredentials(user, password);
        }
    }
}

