/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo.endpoints;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.simple.JSONObject;
import org.pentaho.di.core.exception.KettleAuthException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.repo.controller.RepositoryConnectController;
import org.pentaho.di.ui.repo.model.ErrorModel;
import org.pentaho.di.ui.repo.model.LoginModel;
import org.pentaho.di.ui.repo.model.RepositoryModel;

public class RepositoryEndpoint {
    private static Class<?> PKG = RepositoryEndpoint.class;
    public static final String ERROR_401 = "401";
    private RepositoryConnectController controller;

    public RepositoryEndpoint(RepositoryConnectController controller) {
        this.controller = controller;
    }

    @GET
    @Path(value="/help")
    public Response help() {
        return Response.ok((Object)this.controller.help()).build();
    }

    @GET
    @Path(value="/user")
    public Response user() {
        return Response.ok((Object)this.controller.getCurrentUser()).build();
    }

    @GET
    @Path(value="/connection/create")
    public Response createConnection() {
        return Response.ok((Object)this.controller.createConnection()).build();
    }

    @POST
    @Path(value="/connection/edit")
    public Response editConnection(String database) {
        return Response.ok((Object)this.controller.editDatabaseConnection(database)).build();
    }

    @POST
    @Path(value="/connection/delete")
    public Response deleteConnection(String database) {
        return Response.ok((Object)this.controller.deleteDatabaseConnection(database)).build();
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    public Response login(LoginModel loginModel) {
        try {
            if (this.controller.isRelogin()) {
                this.controller.reconnectToRepository(loginModel.getRepositoryName(), loginModel.getUsername(), loginModel.getPassword());
            } else {
                this.controller.connectToRepository(loginModel.getRepositoryName(), loginModel.getUsername(), loginModel.getPassword());
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            if (e.getMessage().contains(ERROR_401) || e instanceof KettleAuthException) {
                return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidCredentials", (String[])new String[0]))).build();
            }
            return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]))).build();
        }
    }

    @POST
    @Path(value="/add")
    @Consumes(value={"application/json"})
    public Response add(RepositoryModel model) {
        if (this.controller.createRepository(model.getId(), this.controller.modelToMap(model)) != null) {
            return Response.ok().build();
        }
        return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]))).build();
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"application/json"})
    public Response update(RepositoryModel model) {
        if (this.controller.updateRepository(model.getId(), this.controller.modelToMap(model))) {
            return Response.ok().build();
        }
        return Response.serverError().entity((Object)new ErrorModel(BaseMessages.getString(PKG, (String)"RepositoryConnection.Error.InvalidServer", (String[])new String[0]))).build();
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response repositories() {
        return Response.ok((Object)this.controller.getRepositories()).build();
    }

    @GET
    @Path(value="/find/{repo : .+}")
    @Produces(value={"application/json"})
    public Response repository(@PathParam(value="repo") String repo) {
        return Response.ok((Object)this.controller.getRepository(repo)).build();
    }

    @POST
    @Path(value="/default/set")
    @Consumes(value={"application/json"})
    public Response setDefault(RepositoryModel model) {
        return Response.ok((Object)this.controller.setDefaultRepository(model.getDisplayName())).build();
    }

    @POST
    @Path(value="/default/clear")
    @Consumes(value={"application/json"})
    public Response setDefault() {
        return Response.ok((Object)this.controller.clearDefaultRepository()).build();
    }

    @POST
    @Path(value="/duplicate")
    @Consumes(value={"application/json"})
    public Response duplicate(RepositoryModel model) {
        return Response.ok((Object)this.controller.checkDuplicate(model.getDisplayName())).build();
    }

    @POST
    @Path(value="/remove")
    @Consumes(value={"application/json"})
    public Response delete(RepositoryModel model) {
        return Response.ok((Object)this.controller.deleteRepository(model.getDisplayName())).build();
    }

    @GET
    @Path(value="/types")
    @Consumes(value={"application/json"})
    public Response types() {
        return Response.ok((Object)this.controller.getPlugins()).build();
    }

    @GET
    @Path(value="/databases")
    @Produces(value={"application/json"})
    public Response databases() {
        return Response.ok((Object)this.controller.getDatabases()).build();
    }

    @GET
    @Path(value="/browse")
    @Produces(value={"application/json"})
    public Response browse() {
        String path = "/";
        try {
            path = this.controller.browse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"path", (Object)path);
        return Response.ok((Object)jsonObject.toJSONString()).build();
    }
}

