/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class CopyTable
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CopyTable.class);
    static final String NAME = "copytable";
    long startTime = 0L;
    long endTime = Long.MAX_VALUE;
    int batch = Integer.MAX_VALUE;
    int cacheRow = -1;
    int versions = -1;
    String tableName = null;
    String startRow = null;
    String stopRow = null;
    String dstTableName = null;
    String peerAddress = null;
    String families = null;
    boolean allCells = false;
    static boolean shuffle = false;
    boolean bulkload = false;
    Path bulkloadDir = null;
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";

    public Job createSubmittableJob(String[] args) throws IOException {
        Job job;
        block38: {
            if (!this.doCommandLine(args)) {
                return null;
            }
            job = Job.getInstance((Configuration)this.getConf(), (String)this.getConf().get(JOB_NAME_CONF_KEY, "copytable_" + this.tableName));
            job.setJarByClass(CopyTable.class);
            Scan scan = new Scan();
            scan.setBatch(this.batch);
            scan.setCacheBlocks(false);
            if (this.cacheRow > 0) {
                scan.setCaching(this.cacheRow);
            } else {
                scan.setCaching(this.getConf().getInt("hbase.client.scanner.caching", 100));
            }
            scan.setTimeRange(this.startTime, this.endTime);
            if (this.allCells) {
                scan.setRaw(true);
            }
            if (shuffle) {
                job.getConfiguration().set("hbase.mapreduce.inputtable.shufflemaps", "true");
            }
            if (this.versions >= 0) {
                scan.setMaxVersions(this.versions);
            }
            if (this.startRow != null) {
                scan.setStartRow(Bytes.toBytesBinary((String)this.startRow));
            }
            if (this.stopRow != null) {
                scan.setStopRow(Bytes.toBytesBinary((String)this.stopRow));
            }
            if (this.families != null) {
                String[] fams = this.families.split(",");
                HashMap<String, String> cfRenameMap = new HashMap<String, String>();
                for (String fam : fams) {
                    String sourceCf;
                    if (fam.contains(":")) {
                        String[] srcAndDest = fam.split(":", 2);
                        sourceCf = srcAndDest[0];
                        String destCf = srcAndDest[1];
                        cfRenameMap.put(sourceCf, destCf);
                    } else {
                        sourceCf = fam;
                    }
                    scan.addFamily(Bytes.toBytes((String)sourceCf));
                }
                Import.configureCfRenaming(job.getConfiguration(), cfRenameMap);
            }
            job.setNumReduceTasks(0);
            if (this.bulkload) {
                TableMapReduceUtil.initTableMapperJob(this.tableName, scan, Import.CellImporter.class, null, null, job);
                TableInputFormat.configureSplitTable(job, TableName.valueOf((String)this.dstTableName));
                FileSystem fs = FileSystem.get((Configuration)this.getConf());
                Random rand = new Random();
                Path root = new Path(fs.getWorkingDirectory(), NAME);
                fs.mkdirs(root);
                do {
                    this.bulkloadDir = new Path(root, "" + rand.nextLong());
                } while (fs.exists(this.bulkloadDir));
                System.out.println("HFiles will be stored at " + this.bulkloadDir);
                HFileOutputFormat2.setOutputPath((Job)job, (Path)this.bulkloadDir);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
                     Admin admin = conn.getAdmin();){
                    HFileOutputFormat2.configureIncrementalLoadMap(job, admin.getDescriptor(TableName.valueOf((String)this.dstTableName)));
                    break block38;
                }
            }
            TableMapReduceUtil.initTableMapperJob(this.tableName, scan, Import.Importer.class, null, null, job);
            TableMapReduceUtil.initTableReducerJob(this.dstTableName, null, job, null, this.peerAddress, null, null);
        }
        return job;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: CopyTable [general options] [--starttime=X] [--endtime=Y] [--new.name=NEW] [--peer.adr=ADR] <tablename>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" rs.class     hbase.regionserver.class of the peer cluster");
        System.err.println("              specify if different from current cluster");
        System.err.println(" rs.impl      hbase.regionserver.impl of the peer cluster");
        System.err.println(" startrow     the start row");
        System.err.println(" stoprow      the stop row");
        System.err.println(" starttime    beginning of the time range (unixtime in millis)");
        System.err.println("              without endtime means from starttime to forever");
        System.err.println(" endtime      end of the time range.  Ignored if no starttime specified.");
        System.err.println(" versions     number of cell versions to copy");
        System.err.println(" new.name     new table's name");
        System.err.println(" peer.adr     Address of the peer cluster given in the format");
        System.err.println("              hbase.zookeeper.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent");
        System.err.println(" families     comma-separated list of families to copy");
        System.err.println("              To copy from cf1 to cf2, give sourceCfName:destCfName. ");
        System.err.println("              To keep the same name, just give \"cfName\"");
        System.err.println(" all.cells    also copy delete markers and deleted cells");
        System.err.println(" bulkload     Write input into HFiles and bulk load to the destination table");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" tablename    Name of the table to copy");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To copy 'TestTable' to a cluster that uses replication for a 1 hour window:");
        System.err.println(" $ hbase org.apache.hadoop.hbase.mapreduce.CopyTable --starttime=1265875194289 --endtime=1265878794289 --peer.adr=server1,server2,server3:2181:/hbase --families=myOldCf:myNewCf,cf2,cf3 TestTable ");
        System.err.println("For performance consider the following general option:\n  It is recommended that you set the following to >=100. A higher value uses more memory but\n  decreases the round trip time to the server and may increase performance.\n    -Dhbase.client.scanner.caching=100\n  The following should always be set to false, to prevent writing data twice, which may produce \n  inaccurate results.\n    -Dmapreduce.map.speculative=false");
    }

    private boolean doCommandLine(String[] args) {
        if (args.length < 1) {
            CopyTable.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    CopyTable.printUsage(null);
                    return false;
                }
                String startRowArgKey = "--startrow=";
                if (cmd.startsWith("--startrow=")) {
                    this.startRow = cmd.substring("--startrow=".length());
                    continue;
                }
                String stopRowArgKey = "--stoprow=";
                if (cmd.startsWith("--stoprow=")) {
                    this.stopRow = cmd.substring("--stoprow=".length());
                    continue;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    this.startTime = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    this.endTime = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String batchArgKey = "--batch=";
                if (cmd.startsWith("--batch=")) {
                    this.batch = Integer.parseInt(cmd.substring("--batch=".length()));
                    continue;
                }
                String cacheRowArgKey = "--cacheRow=";
                if (cmd.startsWith("--cacheRow=")) {
                    this.cacheRow = Integer.parseInt(cmd.substring("--cacheRow=".length()));
                    continue;
                }
                String versionsArgKey = "--versions=";
                if (cmd.startsWith("--versions=")) {
                    this.versions = Integer.parseInt(cmd.substring("--versions=".length()));
                    continue;
                }
                String newNameArgKey = "--new.name=";
                if (cmd.startsWith("--new.name=")) {
                    this.dstTableName = cmd.substring("--new.name=".length());
                    continue;
                }
                String peerAdrArgKey = "--peer.adr=";
                if (cmd.startsWith("--peer.adr=")) {
                    this.peerAddress = cmd.substring("--peer.adr=".length());
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    this.families = cmd.substring("--families=".length());
                    continue;
                }
                if (cmd.startsWith("--all.cells")) {
                    this.allCells = true;
                    continue;
                }
                if (cmd.startsWith("--bulkload")) {
                    this.bulkload = true;
                    continue;
                }
                if (cmd.startsWith("--shuffle")) {
                    shuffle = true;
                    continue;
                }
                if (i == args.length - 1) {
                    this.tableName = cmd;
                    continue;
                }
                CopyTable.printUsage("Invalid argument '" + cmd + "'");
                return false;
            }
            if (this.dstTableName == null && this.peerAddress == null) {
                CopyTable.printUsage("At least a new table name or a peer address must be specified");
                return false;
            }
            if (this.endTime != 0L && this.startTime > this.endTime) {
                CopyTable.printUsage("Invalid time range filter: starttime=" + this.startTime + " >  endtime=" + this.endTime);
                return false;
            }
            if (this.bulkload && this.peerAddress != null) {
                CopyTable.printUsage("Remote bulkload is not supported!");
                return false;
            }
            if (this.dstTableName == null) {
                this.dstTableName = this.tableName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CopyTable.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new CopyTable(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        FileSystem fs;
        Job job = this.createSubmittableJob(args);
        if (job == null) {
            return 1;
        }
        if (!job.waitForCompletion(true)) {
            LOG.info("Map-reduce job failed!");
            if (this.bulkload) {
                LOG.info("Files are not bulkloaded!");
            }
            return 1;
        }
        int code = 0;
        if (this.bulkload && (code = new LoadIncrementalHFiles(this.getConf()).run(new String[]{this.bulkloadDir.toString(), this.dstTableName})) == 0 && !(fs = FileSystem.get((Configuration)this.getConf())).delete(this.bulkloadDir, true)) {
            LOG.error("Deleting folder " + this.bulkloadDir + " failed!");
            code = 1;
        }
        return code;
    }
}

